/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.core;

import com.github.fracpete.processoutput4j.core.ErrorLogger;
import com.github.fracpete.processoutput4j.core.impl.StderrErrorLogger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class AbstractProcessRunnable
implements Runnable {
    protected int m_PollInterval;
    protected ErrorLogger m_ErrorLogger;
    protected BlockingQueue<Process> m_Queue;
    protected Process m_Process;
    protected boolean m_Running;
    protected boolean m_Stopped;

    public AbstractProcessRunnable() {
        this(1000, new StderrErrorLogger());
    }

    public AbstractProcessRunnable(int pollInterval, ErrorLogger errorLogger) {
        this.m_PollInterval = pollInterval;
        this.m_ErrorLogger = errorLogger;
        this.m_Queue = new ArrayBlockingQueue<Process>(1);
        this.m_Process = null;
        this.m_Running = false;
        this.m_Stopped = false;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public void setProcess(Process value) {
        this.m_Queue.add(value);
    }

    public Process getProcess() {
        return this.m_Process;
    }

    protected void logError(String msg) {
        this.m_ErrorLogger.logError(msg);
    }

    protected void logError(String msg, Throwable t) {
        this.m_ErrorLogger.logError(msg, t);
    }

    protected abstract void doRun();

    @Override
    public void run() {
        this.m_Running = true;
        try {
            while (this.m_Process == null && !this.isStopped()) {
                try {
                    this.m_Process = this.m_Queue.poll(this.m_PollInterval, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {}
            }
            if (this.isStopped()) {
                return;
            }
            this.doRun();
        }
        catch (Exception e) {
            this.logError("Failed to process #" + this.m_Process.hashCode() + ":", e);
        }
        this.m_Running = false;
    }
}

