/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import com.github.fge.jsonschema.messages.ProcessingErrors;
import com.github.fge.jsonschema.processing.ProcessingResult;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.equivalence.Equivalences;
import com.google.common.base.Equivalence;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

public final class CachingProcessor<IN extends MessageProvider, OUT extends MessageProvider>
implements Processor<IN, OUT> {
    private final Processor<IN, OUT> processor;
    private final Equivalence<IN> equivalence;
    private final LoadingCache<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> cache;

    public CachingProcessor(Processor<IN, OUT> processor) {
        this(processor, Equivalences.equals());
    }

    public CachingProcessor(Processor<IN, OUT> processor, Equivalence<IN> equivalence) {
        if (processor == null) {
            throw new ProcessingError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        if (equivalence == null) {
            throw new ProcessingError(new ProcessingMessage().message(ProcessingErrors.NULL_EQUIVALENCE));
        }
        this.processor = processor;
        this.equivalence = equivalence;
        this.cache = CacheBuilder.newBuilder().build(this.loader());
    }

    @Override
    public OUT process(ProcessingReport report, IN input) throws ProcessingException {
        ProcessingResult result;
        try {
            result = (ProcessingResult)this.cache.get((Object)this.equivalence.wrap(input));
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
        report.mergeWith(result.getReport());
        return (OUT)result.getResult();
    }

    private CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> loader() {
        return new CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>>(){

            public ProcessingResult<OUT> load(Equivalence.Wrapper<IN> key) throws ProcessingException {
                MessageProvider input = (MessageProvider)key.get();
                ListProcessingReport report = new ListProcessingReport(LogLevel.DEBUG, LogLevel.NONE);
                return ProcessingResult.of(CachingProcessor.this.processor, report, input);
            }
        };
    }

    public String toString() {
        return "CACHED[" + this.processor + ']';
    }
}

