/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeTaskExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.util.ArrayList;
import java.util.List;

final class DefaultPnpmRunner
extends NodeTaskExecutor
implements PnpmRunner {
    static final String TASK_NAME = "pnpm";

    public DefaultPnpmRunner(NodeExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getPnpmPath().getAbsolutePath(), DefaultPnpmRunner.buildArguments(proxyConfig, npmRegistryURL));
        if (!config.getPnpmPath().exists() && config.getPnpmCjsPath().exists()) {
            this.setTaskLocation(config.getPnpmCjsPath().getAbsolutePath());
        }
    }

    static List<String> buildArguments(ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = null;
            if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
                proxy = proxyConfig.getProxyForUrl(npmRegistryURL);
            }
            if (proxy == null) {
                proxy = proxyConfig.getSecureProxy();
            }
            if (proxy == null) {
                proxy = proxyConfig.getInsecureProxy();
            }
            arguments.add("--https-proxy=" + proxy.getUri().toString());
            arguments.add("--proxy=" + proxy.getUri().toString());
            String nonProxyHosts = proxy.getNonProxyHosts();
            if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                arguments.add("--noproxy=" + nonProxyHosts.replace('|', ','));
            }
        }
        return arguments;
    }
}

