/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.BunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.BunRunner;
import com.github.eirslett.maven.plugins.frontend.lib.BunTaskExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.util.ArrayList;
import java.util.List;

final class DefaultBunRunner
extends BunTaskExecutor
implements BunRunner {
    private static final String TASK_NAME = "bun";

    public DefaultBunRunner(BunExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getBunPath().getAbsolutePath(), DefaultBunRunner.buildArguments(proxyConfig, npmRegistryURL));
    }

    private static List<String> buildArguments(ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = null;
            if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
                proxy = proxyConfig.getProxyForUrl(npmRegistryURL);
            }
            if (proxy == null) {
                proxy = proxyConfig.getSecureProxy();
            }
            if (proxy == null) {
                proxy = proxyConfig.getInsecureProxy();
            }
            arguments.add("--https-proxy=" + proxy.getUri().toString());
            arguments.add("--proxy=" + proxy.getUri().toString());
        }
        return arguments;
    }
}

