/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.paukov.combinatorics3.SimplePermutationGenerator;

class DuplicatedPermutationIterator<T>
implements Iterator<List<T>> {
    private final int length;
    private List<T> currentPermutation;
    private long currentIndex = 0L;
    private int[] data = null;
    private boolean firstIteration = true;
    private List<T> initialOrderedPermutation;

    DuplicatedPermutationIterator(SimplePermutationGenerator<T> generator) {
        this.length = generator.originalVector.size();
        this.data = new int[this.length];
        List originalVector = generator.originalVector;
        ArrayList<T> initialPermutation = new ArrayList<T>();
        LinkedHashSet initialSet = new LinkedHashSet(originalVector);
        int dataValue = 0;
        int dataIndex = 0;
        this.initialOrderedPermutation = new ArrayList(initialSet);
        for (T value : this.initialOrderedPermutation) {
            ++dataValue;
            if (initialPermutation.contains(value)) continue;
            int count = DuplicatedPermutationIterator.intcountElements(originalVector, value);
            for (int countIndex = 0; countIndex < count; ++countIndex) {
                this.data[dataIndex++] = dataValue;
                initialPermutation.add(value);
            }
        }
        this.currentIndex = 0L;
        this.currentPermutation = new ArrayList<T>();
        for (int i = 0; i < this.length; ++i) {
            int index = this.data[i] - 1;
            this.currentPermutation.add(this.initialOrderedPermutation.get(index));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished() || this.firstIteration;
    }

    @Override
    public List<T> next() {
        int i;
        if (this.firstIteration) {
            this.firstIteration = false;
            return this.currentPermutation;
        }
        int k = this.data.length - 2;
        while (this.data[k] >= this.data[k + 1]) {
            --k;
        }
        int l = this.data.length - 1;
        while (this.data[k] >= this.data[l]) {
            --l;
        }
        DuplicatedPermutationIterator.swap(this.data, k, l);
        int newLength = this.data.length - (k + 1);
        for (i = 0; i < newLength / 2; ++i) {
            DuplicatedPermutationIterator.swap(this.data, k + 1 + i, this.data.length - i - 1);
        }
        ++this.currentIndex;
        this.currentPermutation = new ArrayList<T>();
        for (i = 0; i < this.length; ++i) {
            int index = this.data[i] - 1;
            this.currentPermutation.add(this.initialOrderedPermutation.get(index));
        }
        return this.currentPermutation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "DuplicatedPermutationIterator=[#" + (this.currentIndex + 1L) + ", " + this.currentPermutation + "]";
    }

    private static void swap(int[] data, int k, int l) {
        int temp = data[k];
        data[k] = data[l];
        data[l] = temp;
    }

    private boolean isFinished() {
        int k = this.data.length - 2;
        while (this.data[k] >= this.data[k + 1]) {
            if (--k >= 0) continue;
            return true;
        }
        return false;
    }

    private static <T> int intcountElements(List<T> list, T value) {
        return Math.toIntExact(list.stream().filter(item -> item.equals(value)).count());
    }
}

