/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.converters.AbstractJava8DateTimeConverter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class OffsetDateTimeConverter
extends AbstractJava8DateTimeConverter {
    public OffsetDateTimeConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    public Object convert(Class destClass, Object srcObject) {
        OffsetDateTime offsetDateTime = this.convertToOffsetDateTime(srcObject);
        if (offsetDateTime != null) {
            if (OffsetTime.class.isAssignableFrom(destClass)) {
                return offsetDateTime.toOffsetTime();
            }
            return offsetDateTime;
        }
        return super.convert(destClass, srcObject);
    }

    private OffsetDateTime convertToOffsetDateTime(Object srcObject) {
        Class<?> srcObjectClass = srcObject.getClass();
        if (Date.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = ((Date)srcObject).toInstant();
            return OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (Instant.class.isAssignableFrom(srcObjectClass)) {
            return OffsetDateTime.ofInstant((Instant)srcObject, ZoneId.systemDefault());
        }
        if (Long.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = Instant.ofEpochMilli((Long)srcObject);
            return OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return null;
    }
}

