/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap.generator;

import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.generator.MappingType;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.DozerField;
import com.github.dozermapper.core.fieldmap.GenericFieldMap;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.MappingUtils;

public final class GeneratorUtils {
    private static final String CLASS = "class";
    private static final String CALLBACK = "callback";
    private static final String CALLBACKS = "callbacks";

    private GeneratorUtils() {
    }

    public static boolean shouldIgnoreField(String fieldName, Class<?> srcType, Class<?> destType, BeanContainer beanContainer) {
        if (CLASS.equals(fieldName)) {
            return true;
        }
        return !(!CALLBACK.equals(fieldName) && !CALLBACKS.equals(fieldName) || !MappingUtils.isProxy(srcType, beanContainer) && !MappingUtils.isProxy(destType, beanContainer));
    }

    public static void addGenericMapping(MappingType mappingType, ClassMap classMap, Configuration configuration, String srcName, String destName, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        GenericFieldMap fieldMap = new GenericFieldMap(classMap, beanContainer, destBeanCreator, propertyDescriptorFactory);
        DozerField srcField = new DozerField(srcName, null);
        DozerField destField = new DozerField(destName, null);
        fieldMap.setSrcField(srcField);
        fieldMap.setDestField(destField);
        switch (mappingType) {
            case FIELD_TO_FIELD: {
                srcField.setAccessible(true);
                destField.setAccessible(true);
                break;
            }
            case FIELD_TO_SETTER: {
                srcField.setAccessible(true);
                break;
            }
        }
        MappingUtils.applyGlobalCopyByReference(configuration, fieldMap, classMap);
        classMap.addFieldMapping(fieldMap);
    }
}

