/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.cache;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.cache.Cache;
import com.github.dozermapper.core.cache.CacheManager;
import com.github.dozermapper.core.cache.DefaultCache;
import com.github.dozermapper.core.util.MappingUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class DefaultCacheManager
implements CacheManager {
    private final Map<String, Cache> cachesMap = new HashMap<String, Cache>();

    @Override
    public Collection<Cache> getCaches() {
        return new HashSet<Cache>(this.cachesMap.values());
    }

    @Override
    public Cache getCache(String name) throws MappingException {
        Cache cache = this.cachesMap.get(name);
        if (cache == null) {
            MappingUtils.throwMappingException("Unable to find cache with name: " + name);
        }
        return cache;
    }

    @Override
    public Cache putCache(String name, int maxElementsInMemory) {
        return this.putCache(new DefaultCache(name, maxElementsInMemory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache putCache(Cache cache) throws MappingException {
        Map<String, Cache> map = this.cachesMap;
        synchronized (map) {
            String name = cache.getName();
            if (this.cacheExists(name)) {
                MappingUtils.throwMappingException("Cache already exists with name: " + name);
            }
            this.cachesMap.put(name, cache);
            return cache;
        }
    }

    @Override
    public Collection<String> getCacheNames() {
        HashSet<String> results = new HashSet<String>();
        for (Map.Entry<String, Cache> entry : this.cachesMap.entrySet()) {
            results.add(entry.getKey());
        }
        return results;
    }

    @Override
    public void clearAllEntries() {
        for (Cache cache : this.cachesMap.values()) {
            cache.clear();
        }
    }

    @Override
    public boolean cacheExists(String name) {
        return this.cachesMap.containsKey(name);
    }
}

