/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.fluent;

import com.github.dozermapper.core.builder.BeanMappingsBuilder;
import com.github.dozermapper.core.builder.model.elengine.ELMappingsDefinition;
import com.github.dozermapper.core.builder.model.jaxb.ConfigurationDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingsDefinition;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.MappingFileData;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.el.ELEngine;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import java.util.Arrays;
import java.util.List;

public abstract class BeanMappingsFluentBuilder
implements BeanMappingsBuilder {
    private final MappingsDefinition mappingsDefinition;

    public BeanMappingsFluentBuilder(ELEngine elEngine) {
        this.mappingsDefinition = new ELMappingsDefinition(elEngine);
        this.configure();
    }

    protected abstract void configure();

    protected ConfigurationDefinition configuration() {
        return this.mappingsDefinition.withConfiguration();
    }

    protected MappingDefinition mapping() {
        return this.mappingsDefinition.addMapping();
    }

    @Override
    public List<MappingFileData> build(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        Configuration configuration = null;
        if (this.mappingsDefinition.getConfiguration() != null) {
            configuration = this.mappingsDefinition.getConfiguration().build(beanContainer);
        }
        MappingFileData data = new MappingFileData();
        data.setConfiguration(configuration);
        data.getClassMaps().addAll(this.mappingsDefinition.build(configuration, beanContainer, destBeanCreator, propertyDescriptorFactory));
        return Arrays.asList(data);
    }
}

