/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.DockerClientConfig;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

public class JsonResponseCallbackHandler<T>
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ObjectMapper objectMapper;
    private TypeReference<T> typeReference;
    private ResultCallback<T> callback;

    @Deprecated
    public JsonResponseCallbackHandler(TypeReference<T> typeReference, ResultCallback<T> callback) {
        this(DockerClientConfig.getDefaultObjectMapper(), typeReference, callback);
    }

    public JsonResponseCallbackHandler(ObjectMapper objectMapper, TypeReference<T> typeReference, ResultCallback<T> callback) {
        this.objectMapper = objectMapper;
        this.typeReference = typeReference;
        this.callback = callback;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] buffer = new byte[msg.readableBytes()];
        msg.readBytes(buffer);
        msg.discardReadBytes();
        Object object = null;
        try {
            object = this.objectMapper.readValue(buffer, this.typeReference);
        }
        catch (Exception e) {
            this.callback.onError((Throwable)e);
            throw new RuntimeException(e);
        }
        this.callback.onNext(object);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.callback.onError(cause);
        ctx.close();
    }
}

