/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.junit5.integration;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.util.ClassUtils;
import com.github.database.rider.junit5.jdbc.ConnectionManager;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.test.extensions.junit5.MicronautJunit5Extension;
import java.util.Optional;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Micronaut {
    public static boolean isEnabled(ExtensionContext extensionContext) {
        return Micronaut.isExtensionEnabled(extensionContext) && Micronaut.getApplicationContext(extensionContext).isPresent();
    }

    public static ConnectionHolder getConnectionFromMicronautContext(ExtensionContext extensionContext, String executorId) {
        String configuredDataSourceBeanName = ConnectionManager.getConfiguredDataSourceBeanName(extensionContext);
        DataSource dataSource = Micronaut.getDataSourceFromMicronautContext(extensionContext, configuredDataSourceBeanName);
        return ConnectionManager.getConnectionHolder(executorId, dataSource);
    }

    private static boolean isExtensionEnabled(ExtensionContext extensionContext) {
        try {
            return ClassUtils.isOnClasspath((String)"io.micronaut.test.extensions.junit5.MicronautJunit5Extension");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Optional<ApplicationContext> getApplicationContext(ExtensionContext extensionContext) {
        ExtensionContext.Store micronautStore = extensionContext.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{MicronautJunit5Extension.class}));
        if (micronautStore != null) {
            try {
                ApplicationContext appContext = (ApplicationContext)micronautStore.get(ApplicationContext.class);
                if (appContext != null) {
                    return Optional.of(appContext);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static DataSource getDataSourceFromMicronautContext(ExtensionContext extensionContext, String beanName) {
        Optional<ApplicationContext> context = Micronaut.getApplicationContext(extensionContext);
        if (context.isPresent()) {
            return beanName.isEmpty() ? (DataSource)context.get().getBean(DataSource.class) : (DataSource)context.get().getBean(DataSource.class, Qualifiers.byName((String)beanName));
        }
        throw new RuntimeException("Micronaut context is not available for test: " + ((Class)extensionContext.getTestClass().get()).getName());
    }
}

