/*
 * Decompiled with CFR 0.152.
 */
package repeat;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.model.Statement;

public class RepeatStatement
extends Statement {
    private final int times;
    private final int threads;
    private final long timeout;
    private final TimeUnit unit;
    private final Statement statement;

    public RepeatStatement(int times, int threads, long timeout, TimeUnit unit, Statement statement) {
        this.times = times;
        this.threads = threads;
        this.timeout = timeout;
        this.unit = unit;
        this.statement = statement;
    }

    public void evaluate() throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
        for (int i = 0; i < this.times; ++i) {
            executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        RepeatStatement.this.statement.evaluate();
                    }
                    catch (Throwable throwable) {
                        throw new Exception(throwable);
                    }
                    return null;
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(this.timeout, this.unit);
        executorService.shutdownNow();
    }
}

