/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.util.json;

import cn.binarywang.wx.miniapp.bean.analysis.WxMaUserPortrait;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import me.chanjar.weixin.common.util.json.GsonHelper;
import org.apache.commons.lang3.StringUtils;

public class WxMaUserPortraitGsonAdapter
implements JsonDeserializer<WxMaUserPortrait> {
    public WxMaUserPortrait deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (json == null) {
            return null;
        }
        WxMaUserPortrait portrait = new WxMaUserPortrait();
        JsonObject object = json.getAsJsonObject();
        String refDate = GsonHelper.getString((JsonObject)object, (String)"ref_date");
        portrait.setRefDate(refDate);
        portrait.setVisitUvNew(this.getPortraitItem(object.getAsJsonObject("visit_uv_new")));
        portrait.setVisitUv(this.getPortraitItem(object.getAsJsonObject("visit_uv")));
        return portrait;
    }

    private WxMaUserPortrait.Item getPortraitItem(JsonObject object) {
        if (object == null) {
            return null;
        }
        WxMaUserPortrait.Item item = new WxMaUserPortrait.Item();
        item.setProvince(this.getAsMap(object, "province"));
        item.setCity(this.getAsMap(object, "city"));
        item.setGenders(this.getAsMap(object, "genders"));
        item.setPlatforms(this.getAsMap(object, "platforms"));
        item.setDevices(this.getAsMap(object, "devices"));
        item.setAges(this.getAsMap(object, "ages"));
        return item;
    }

    private Map<String, Long> getAsMap(JsonObject object, String memberName) {
        JsonArray array = object.getAsJsonArray(memberName);
        if (array != null && array.size() > 0) {
            LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>(array.size());
            for (JsonElement element : array) {
                JsonObject elementObject = element.getAsJsonObject();
                String name = GsonHelper.getString((JsonObject)elementObject, (String)"name");
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                Long value = GsonHelper.getLong((JsonObject)elementObject, (String)"value");
                map.put(name, value);
            }
            return map;
        }
        return null;
    }
}

