/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.api.WxOcrService;
import me.chanjar.weixin.common.bean.ocr.WxOcrBankCardResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrBizLicenseResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrCommResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrDrivingLicenseResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrDrivingResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrIdCardResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.mp.util.requestexecuter.ocr.OcrDiscernRequestExecutor;

public class WxMaOcrServiceImpl
implements WxOcrService {
    private static final String IDCARD = "https://api.weixin.qq.com/cv/ocr/idcard?img_url=%s";
    private static final String FILEIDCARD = "https://api.weixin.qq.com/cv/ocr/idcard";
    private static final String BANK_CARD = "https://api.weixin.qq.com/cv/ocr/bankcard?img_url=%s";
    private static final String FILE_BANK_CARD = "https://api.weixin.qq.com/cv/ocr/bankcard";
    private static final String DRIVING = "https://api.weixin.qq.com/cv/ocr/driving?img_url=%s";
    private static final String FILE_DRIVING = "https://api.weixin.qq.com/cv/ocr/driving";
    private static final String DRIVING_LICENSE = "https://api.weixin.qq.com/cv/ocr/drivinglicense?img_url=%s";
    private static final String FILE_DRIVING_LICENSE = "https://api.weixin.qq.com/cv/ocr/drivinglicense";
    private static final String BIZ_LICENSE = "https://api.weixin.qq.com/cv/ocr/bizlicense?img_url=%s";
    private static final String FILE_BIZ_LICENSE = "https://api.weixin.qq.com/cv/ocr/bizlicense";
    private static final String COMM = "https://api.weixin.qq.com/cv/ocr/comm?img_url=%s";
    private static final String FILE_COMM = "https://api.weixin.qq.com/cv/ocr/comm";
    private final WxMaService mainService;

    public WxOcrIdCardResult idCard(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(IDCARD, imgUrl), null);
        return WxOcrIdCardResult.fromJson((String)result);
    }

    public WxOcrIdCardResult idCard(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), FILEIDCARD, imgFile);
        return WxOcrIdCardResult.fromJson((String)result);
    }

    public WxOcrBankCardResult bankCard(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(BANK_CARD, imgUrl), null);
        return WxOcrBankCardResult.fromJson((String)result);
    }

    public WxOcrBankCardResult bankCard(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), FILE_BANK_CARD, imgFile);
        return WxOcrBankCardResult.fromJson((String)result);
    }

    public WxOcrDrivingResult driving(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(DRIVING, imgUrl), null);
        return WxOcrDrivingResult.fromJson((String)result);
    }

    public WxOcrDrivingResult driving(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), FILE_DRIVING, imgFile);
        return WxOcrDrivingResult.fromJson((String)result);
    }

    public WxOcrDrivingLicenseResult drivingLicense(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(DRIVING_LICENSE, imgUrl), null);
        return WxOcrDrivingLicenseResult.fromJson((String)result);
    }

    public WxOcrDrivingLicenseResult drivingLicense(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), FILE_DRIVING_LICENSE, imgFile);
        return WxOcrDrivingLicenseResult.fromJson((String)result);
    }

    public WxOcrBizLicenseResult bizLicense(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(BIZ_LICENSE, imgUrl), null);
        return WxOcrBizLicenseResult.fromJson((String)result);
    }

    public WxOcrBizLicenseResult bizLicense(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), FILE_BIZ_LICENSE, imgFile);
        return WxOcrBizLicenseResult.fromJson((String)result);
    }

    public WxOcrCommResult comm(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(COMM, imgUrl), null);
        return WxOcrCommResult.fromJson((String)result);
    }

    public WxOcrCommResult comm(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), FILE_COMM, imgFile);
        return WxOcrCommResult.fromJson((String)result);
    }

    public WxMaOcrServiceImpl(WxMaService mainService) {
        this.mainService = mainService;
    }
}

