/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaLiveGoodsService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaLiveInfo;
import cn.binarywang.wx.miniapp.bean.WxMaLiveResult;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;

public class WxMaLiveGoodsServiceImpl
implements WxMaLiveGoodsService {
    private final WxMaService wxMaService;

    @Override
    public WxMaLiveResult addGoods(WxMaLiveInfo.Goods goods) throws WxErrorException {
        HashMap<String, WxMaLiveInfo.Goods> map = new HashMap<String, WxMaLiveInfo.Goods>(2);
        map.put("goodsInfo", goods);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/add", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    @Override
    public boolean resetAudit(Integer auditId, Integer goodsId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(4);
        map.put("auditId", auditId);
        map.put("goodsId", goodsId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/resetaudit", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public String auditGoods(Integer goodsId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("goodsId", goodsId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/audit", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get("auditId").getAsString();
    }

    @Override
    public boolean deleteGoods(Integer goodsId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("goodsId", goodsId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/delete", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean updateGoods(WxMaLiveInfo.Goods goods) throws WxErrorException {
        HashMap<String, WxMaLiveInfo.Goods> map = new HashMap<String, WxMaLiveInfo.Goods>(2);
        map.put("goodsInfo", goods);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/update", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public WxMaLiveResult getGoodsWareHouse(List<Integer> goodsIds) throws WxErrorException {
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>(2);
        map.put("goods_ids", goodsIds);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxa/business/getgoodswarehouse", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    @Override
    public WxMaLiveResult getApprovedGoods(Integer offset, Integer limit, Integer status) throws WxErrorException {
        ImmutableMap params = ImmutableMap.of((Object)"status", (Object)status, (Object)"offset", (Object)offset, (Object)"limit", (Object)limit);
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/broadcast/goods/getapproved", Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)params));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        JsonArray goodsArr = jsonObject.getAsJsonArray("goods");
        if (goodsArr.size() > 0) {
            for (int i = 0; i < goodsArr.size(); ++i) {
                JsonObject goods = (JsonObject)goodsArr.get(i);
                goods.addProperty("goods_id", (Number)goods.get("goodsId").getAsInt());
                goods.addProperty("cover_img_url", goods.get("coverImgUrl").getAsString());
                goods.addProperty("price_type", (Number)goods.get("priceType").getAsInt());
                goods.addProperty("third_party_tag", (Number)goods.get("thirdPartyTag").getAsInt());
                goods.addProperty("audit_status", (Number)status);
            }
        }
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    public WxMaLiveGoodsServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

