/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.integration;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import com.github.benmanes.caffeine.jcache.Expirable;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoaderException;
import org.jspecify.annotations.Nullable;

public final class JCacheLoaderAdapter<K, V>
implements CacheLoader<K, Expirable<V>> {
    private static final System.Logger logger = System.getLogger(JCacheLoaderAdapter.class.getName());
    private final JCacheStatisticsMXBean statistics;
    private final EventDispatcher<K, V> dispatcher;
    private final javax.cache.integration.CacheLoader<K, V> delegate;
    private final ExpiryPolicy expiry;
    private final Ticker ticker;
    private CacheProxy<K, V> cache;

    public JCacheLoaderAdapter(javax.cache.integration.CacheLoader<K, V> delegate, EventDispatcher<K, V> dispatcher, ExpiryPolicy expiry, Ticker ticker, JCacheStatisticsMXBean statistics) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.statistics = Objects.requireNonNull(statistics);
        this.delegate = Objects.requireNonNull(delegate);
        this.expiry = Objects.requireNonNull(expiry);
        this.ticker = Objects.requireNonNull(ticker);
    }

    public void setCache(CacheProxy<K, V> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public @Nullable Expirable<V> load(K key) {
        try {
            boolean statsEnabled = this.statistics.isEnabled();
            long start = statsEnabled ? this.ticker.read() : 0L;
            Object value = this.delegate.load(key);
            if (value == null) {
                return null;
            }
            this.dispatcher.publishCreated(this.cache, key, value);
            if (statsEnabled) {
                this.statistics.recordGetTime(start - this.ticker.read());
            }
            return new Expirable<Object>(value, this.expireTimeMillis());
        }
        catch (CacheLoaderException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public Map<K, Expirable<V>> loadAll(Set<? extends K> keys) {
        try {
            boolean statsEnabled = this.statistics.isEnabled();
            long start = statsEnabled ? this.ticker.read() : 0L;
            Map<Object, Expirable> result = this.delegate.loadAll(keys).entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> new Expirable(entry.getValue(), this.expireTimeMillis())));
            for (Map.Entry<Object, Expirable> entry2 : result.entrySet()) {
                this.dispatcher.publishCreated(this.cache, entry2.getKey(), entry2.getValue().get());
            }
            if (statsEnabled) {
                this.statistics.recordGetTime(start - this.ticker.read());
            }
            return result;
        }
        catch (CacheLoaderException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private long expireTimeMillis() {
        try {
            Duration duration = this.expiry.getExpiryForCreation();
            if (duration.isZero()) {
                return 0L;
            }
            if (duration.isEternal()) {
                return Long.MAX_VALUE;
            }
            long millis = TimeUnit.NANOSECONDS.toMillis(this.ticker.read());
            return duration.getAdjustedTime(millis);
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.WARNING, "Exception thrown by expiry policy", (Throwable)e);
            throw e;
        }
    }
}

