/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.expiry;

import java.io.Serializable;
import java.util.Objects;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.jspecify.annotations.Nullable;

public final class JCacheExpiryPolicy
implements ExpiryPolicy,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Duration creation;
    private final @Nullable Duration update;
    private final @Nullable Duration access;

    public JCacheExpiryPolicy(Duration creation, @Nullable Duration update, @Nullable Duration access) {
        this.creation = Objects.requireNonNull(creation);
        this.update = update;
        this.access = access;
    }

    public Duration getExpiryForCreation() {
        return this.creation;
    }

    public @Nullable Duration getExpiryForUpdate() {
        return this.update;
    }

    public @Nullable Duration getExpiryForAccess() {
        return this.access;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpiryPolicy)) {
            return false;
        }
        ExpiryPolicy policy = (ExpiryPolicy)o;
        return Objects.equals(this.creation, policy.getExpiryForCreation()) && Objects.equals(this.update, policy.getExpiryForUpdate()) && Objects.equals(this.access, policy.getExpiryForAccess());
    }

    public int hashCode() {
        return Objects.hash(this.creation, this.update, this.access);
    }
}

