/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import com.github.benmanes.caffeine.jcache.event.EventTypeAwareListener;
import com.github.benmanes.caffeine.jcache.event.EventTypeFilter;
import com.github.benmanes.caffeine.jcache.event.JCacheEntryEvent;
import com.github.benmanes.caffeine.jcache.event.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.EventType;
import org.jspecify.annotations.Nullable;

public final class EventDispatcher<K, V> {
    static final System.Logger logger = System.getLogger(EventDispatcher.class.getName());
    final ConcurrentMap<Registration<K, V>, ConcurrentMap<K, CompletableFuture<@Nullable Void>>> dispatchQueues;
    final ThreadLocal<List<CompletableFuture<@Nullable Void>>> pending = ThreadLocal.withInitial(ArrayList::new);
    final Executor executor;

    public EventDispatcher(Executor executor) {
        this.dispatchQueues = new ConcurrentHashMap<Registration<K, V>, ConcurrentMap<K, CompletableFuture<Void>>>();
        this.executor = Objects.requireNonNull(executor);
    }

    public Set<Registration<K, V>> registrations() {
        return Collections.unmodifiableSet(this.dispatchQueues.keySet());
    }

    public void register(CacheEntryListenerConfiguration<K, V> configuration) {
        if (configuration.getCacheEntryListenerFactory() == null) {
            return;
        }
        EventTypeAwareListener listener = new EventTypeAwareListener((CacheEntryListener)configuration.getCacheEntryListenerFactory().create());
        Factory factory = configuration.getCacheEntryEventFilterFactory();
        CacheEntryEventFilter filter = factory == null ? event -> true : new EventTypeFilter(listener, (CacheEntryEventFilter)factory.create());
        Registration<K, V> registration = new Registration<K, V>(configuration, filter, listener);
        this.dispatchQueues.putIfAbsent(registration, new ConcurrentHashMap());
    }

    public void deregister(CacheEntryListenerConfiguration<K, V> configuration) {
        Objects.requireNonNull(configuration);
        this.dispatchQueues.keySet().removeIf(registration -> configuration.equals(registration.getConfiguration()));
    }

    public void publishCreated(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.CREATED, key, false, null, value, false);
    }

    public void publishUpdated(Cache<K, V> cache, K key, V oldValue, V newValue) {
        this.publish(cache, EventType.UPDATED, key, true, oldValue, newValue, false);
    }

    public void publishRemoved(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.REMOVED, key, true, value, value, false);
    }

    public void publishRemovedQuietly(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.REMOVED, key, true, value, value, true);
    }

    public void publishExpired(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.EXPIRED, key, true, value, value, false);
    }

    public void publishExpiredQuietly(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.EXPIRED, key, true, value, value, true);
    }

    public void awaitSynchronous() {
        List<CompletableFuture<Void>> futures = this.pending.get();
        if (futures.isEmpty()) {
            return;
        }
        try {
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        }
        catch (CompletionException e) {
            logger.log(System.Logger.Level.WARNING, "", (Throwable)e);
        }
        finally {
            futures.clear();
        }
    }

    public void ignoreSynchronous() {
        this.pending.get().clear();
    }

    private void publish(Cache<K, V> cache, EventType eventType, K key, boolean hasOldValue, @Nullable V oldValue, @Nullable V newValue, boolean quiet) {
        if (this.dispatchQueues.isEmpty()) {
            return;
        }
        JCacheEntryEvent event = null;
        for (Map.Entry entry : this.dispatchQueues.entrySet()) {
            Registration registration = (Registration)entry.getKey();
            if (!registration.getCacheEntryListener().isCompatible(eventType)) continue;
            if (event == null) {
                event = new JCacheEntryEvent(cache, eventType, key, hasOldValue, oldValue, newValue);
            }
            if (!registration.getCacheEntryFilter().evaluate(event)) continue;
            JCacheEntryEvent e = event;
            ConcurrentMap dispatchQueue = (ConcurrentMap)entry.getValue();
            CompletableFuture future = dispatchQueue.compute(key, (k, queue) -> {
                Runnable action = () -> registration.getCacheEntryListener().dispatch(e);
                return queue == null ? CompletableFuture.runAsync(action, this.executor) : queue.thenRunAsync(action, this.executor);
            });
            future.whenComplete((result, error) -> {
                if (dispatchQueue.get(key) == future) {
                    dispatchQueue.remove(key, future);
                }
            });
            if (!registration.isSynchronous() || quiet) continue;
            this.pending.get().add(future);
        }
    }
}

