/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.watchdog;

import backtraceio.library.BacktraceClient;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.watchdog.BacktraceThreadWatcher;
import backtraceio.library.watchdog.BacktraceWatchdogShared;
import backtraceio.library.watchdog.OnApplicationNotRespondingEvent;
import java.util.HashMap;
import java.util.Map;

public class BacktraceWatchdog {
    private static final transient String LOG_TAG = BacktraceWatchdog.class.getSimpleName();
    private final BacktraceClient backtraceClient;
    private final boolean sendException;
    private final Map<Thread, BacktraceThreadWatcher> threadsIdWatcher = new HashMap<Thread, BacktraceThreadWatcher>();
    private OnApplicationNotRespondingEvent onApplicationNotRespondingEvent;

    public BacktraceWatchdog(BacktraceClient client, boolean sendException) {
        this.sendException = sendException;
        this.backtraceClient = client;
    }

    public BacktraceWatchdog(BacktraceClient client) {
        this(client, true);
    }

    public void setOnApplicationNotRespondingEvent(OnApplicationNotRespondingEvent onApplicationNotRespondingEvent) {
        this.onApplicationNotRespondingEvent = onApplicationNotRespondingEvent;
    }

    public boolean checkIsAnyThreadIsBlocked() {
        long now = System.currentTimeMillis();
        String now_str = Long.toString(now);
        BacktraceLogger.d(LOG_TAG, "Checking watchdog. Timestamp: " + now_str);
        for (Map.Entry<Thread, BacktraceThreadWatcher> entry : this.threadsIdWatcher.entrySet()) {
            long timeout;
            Thread currentThread = entry.getKey();
            BacktraceThreadWatcher currentWatcher = entry.getValue();
            if (currentThread == null || currentWatcher == null || currentThread == Thread.currentThread() || !currentThread.isAlive() || !currentWatcher.isActive()) continue;
            if (currentWatcher.getCounter() != currentWatcher.getPrivateCounter()) {
                currentWatcher.setPrivateCounter(currentWatcher.getCounter());
                currentWatcher.setLastTimestamp(now);
                continue;
            }
            BacktraceLogger.w(LOG_TAG, String.format("Thread %d %s  might be hung, timestamp: %s", currentThread.getId(), currentThread.getName(), now_str));
            long timestamp = currentWatcher.getLastTimestamp();
            if (now - timestamp <= (timeout = timestamp == 0L ? (long)currentWatcher.getTimeout() : (long)(currentWatcher.getTimeout() + currentWatcher.getDelay()))) continue;
            if (this.sendException) {
                BacktraceWatchdogShared.sendReportCauseBlockedThread(this.backtraceClient, currentThread, this.onApplicationNotRespondingEvent, LOG_TAG);
            }
            return true;
        }
        return false;
    }

    public void registerThread(Thread thread, int timeout, int delay) {
        this.threadsIdWatcher.put(thread, new BacktraceThreadWatcher(timeout, delay));
    }

    public void unRegisterThread(Thread thread) {
        this.threadsIdWatcher.remove(thread);
    }

    public void tick(Thread thread) {
        if (!this.threadsIdWatcher.containsKey(thread)) {
            return;
        }
        BacktraceThreadWatcher threadWatcher = this.threadsIdWatcher.get(thread);
        if (threadWatcher == null) {
            return;
        }
        threadWatcher.tickCounter();
    }

    public void activateWatcher(Thread thread) {
        if (!this.threadsIdWatcher.containsKey(thread)) {
            return;
        }
        BacktraceThreadWatcher threadWatcher = this.threadsIdWatcher.get(thread);
        if (threadWatcher == null) {
            return;
        }
        threadWatcher.setActive(true);
    }

    public void deactivateWatcher(Thread thread) {
        if (!this.threadsIdWatcher.containsKey(thread)) {
            return;
        }
        BacktraceThreadWatcher threadWatcher = this.threadsIdWatcher.get(thread);
        if (threadWatcher == null) {
            return;
        }
        threadWatcher.setActive(false);
    }
}

