/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.watchdog;

import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import backtraceio.library.BacktraceClient;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.watchdog.BacktraceThreadWatcher;
import backtraceio.library.watchdog.BacktraceWatchdogShared;
import backtraceio.library.watchdog.OnApplicationNotRespondingEvent;
import java.util.Calendar;

public class BacktraceANRWatchdog
extends Thread {
    private static final transient String LOG_TAG = BacktraceANRWatchdog.class.getSimpleName();
    private static final transient int DEFAULT_ANR_TIMEOUT = 5000;
    private final BacktraceClient backtraceClient;
    private final boolean debug;
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private final int timeout;
    private OnApplicationNotRespondingEvent onApplicationNotRespondingEvent;
    private volatile boolean shouldStop = false;

    public BacktraceANRWatchdog(BacktraceClient client) {
        this(client, 5000);
    }

    public BacktraceANRWatchdog(BacktraceClient client, int timeout) {
        this(client, timeout, false);
    }

    public BacktraceANRWatchdog(BacktraceClient client, int timeout, boolean debug) {
        BacktraceLogger.d(LOG_TAG, "Start monitoring ANR");
        this.backtraceClient = client;
        this.timeout = timeout;
        this.debug = debug;
        this.start();
    }

    public void setOnApplicationNotRespondingEvent(OnApplicationNotRespondingEvent onApplicationNotRespondingEvent) {
        this.onApplicationNotRespondingEvent = onApplicationNotRespondingEvent;
    }

    @Override
    public void run() {
        if (this.debug && (Debug.isDebuggerConnected() || Debug.waitingForDebugger())) {
            BacktraceLogger.w(LOG_TAG, "Detected a debugger connection. ANR Watchdog is disabled");
            return;
        }
        Boolean reported = false;
        while (!this.shouldStop && !this.isInterrupted()) {
            String dateTimeNow = Calendar.getInstance().getTime().toString();
            BacktraceLogger.d(LOG_TAG, "ANR WATCHDOG - " + dateTimeNow);
            final BacktraceThreadWatcher threadWatcher = new BacktraceThreadWatcher(0, 0);
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    threadWatcher.tickCounter();
                }
            });
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                BacktraceLogger.e(LOG_TAG, "Thread is interrupted", e);
                return;
            }
            threadWatcher.tickPrivateCounter();
            if (threadWatcher.getCounter() == threadWatcher.getPrivateCounter()) {
                reported = false;
                BacktraceLogger.d(LOG_TAG, "ANR is not detected");
                continue;
            }
            if (reported.booleanValue()) continue;
            reported = true;
            BacktraceWatchdogShared.sendReportCauseBlockedThread(this.backtraceClient, Looper.getMainLooper().getThread(), this.onApplicationNotRespondingEvent, LOG_TAG);
        }
    }

    public void stopMonitoringAnr() {
        BacktraceLogger.d(LOG_TAG, "Stop monitoring ANR");
        this.shouldStop = true;
    }
}

