/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import backtraceio.library.common.BacktraceTimeHelper;
import backtraceio.library.interfaces.Api;
import backtraceio.library.models.metrics.EventsPayload;
import backtraceio.library.models.metrics.UniqueEvent;
import backtraceio.library.models.metrics.UniqueEventsPayload;
import backtraceio.library.services.BacktraceEventsHandler;
import backtraceio.library.services.BacktraceHandlerThread;
import backtraceio.library.services.BacktraceMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;

public class UniqueEventsHandler
extends BacktraceEventsHandler<UniqueEvent> {
    private static final transient String LOG_TAG = UniqueEventsHandler.class.getSimpleName();
    private static final String urlPrefix = "unique-events";

    public UniqueEventsHandler(BacktraceMetrics backtraceMetrics, Api api, BacktraceHandlerThread backtraceHandlerThread) {
        super(backtraceMetrics, api, backtraceHandlerThread, urlPrefix);
    }

    protected UniqueEventsPayload getEventsPayload() {
        Map<String, Object> attributes = this.backtraceMetrics.createLocalAttributes(null);
        for (UniqueEvent event : this.events) {
            event.update(BacktraceTimeHelper.getTimestampSeconds(), attributes);
        }
        UniqueEventsPayload payload = new UniqueEventsPayload(this.events, this.application, this.appVersion);
        return payload;
    }

    @Override
    protected void sendEvents(ConcurrentLinkedDeque<UniqueEvent> events) {
        UniqueEventsPayload payload = this.getEventsPayload();
        this.api.sendEventsPayload(payload);
    }

    @Override
    protected void sendEventsPayload(EventsPayload<UniqueEvent> payload) {
        this.api.sendEventsPayload((UniqueEventsPayload)payload);
    }
}

