/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import backtraceio.library.interfaces.Api;
import backtraceio.library.models.metrics.EventsPayload;
import backtraceio.library.models.metrics.SummedEvent;
import backtraceio.library.models.metrics.SummedEventsPayload;
import backtraceio.library.services.BacktraceEventsHandler;
import backtraceio.library.services.BacktraceHandlerThread;
import backtraceio.library.services.BacktraceMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;

public class SummedEventsHandler
extends BacktraceEventsHandler<SummedEvent> {
    private static final transient String LOG_TAG = SummedEventsHandler.class.getSimpleName();
    private static final String urlPrefix = "summed-events";

    public SummedEventsHandler(BacktraceMetrics backtraceMetrics, Api api, BacktraceHandlerThread backtraceHandlerThread) {
        super(backtraceMetrics, api, backtraceHandlerThread, urlPrefix);
    }

    protected SummedEventsPayload getEventsPayload() {
        Map<String, Object> attributes = this.backtraceMetrics.createLocalAttributes(null);
        ConcurrentLinkedDeque<SummedEvent> eventsCopy = new ConcurrentLinkedDeque<SummedEvent>();
        for (SummedEvent event : this.events) {
            event.addAttributes(attributes);
            eventsCopy.addLast(new SummedEvent(event));
        }
        this.events.clear();
        SummedEventsPayload payload = new SummedEventsPayload(eventsCopy, this.application, this.appVersion);
        return payload;
    }

    @Override
    protected void sendEvents(ConcurrentLinkedDeque<SummedEvent> events) {
        SummedEventsPayload payload = this.getEventsPayload();
        this.api.sendEventsPayload(payload);
    }

    @Override
    protected void sendEventsPayload(EventsPayload<SummedEvent> payload) {
        this.api.sendEventsPayload((SummedEventsPayload)payload);
    }

    @Override
    protected void onMaximumAttemptsReached(ConcurrentLinkedDeque<SummedEvent> events) {
        if (this.events.size() + events.size() < this.getMaximumNumberOfEvents()) {
            for (SummedEvent event : events) {
                this.events.addFirst(event);
            }
        }
    }
}

