/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import backtraceio.library.common.BacktraceSerializeHelper;
import backtraceio.library.interfaces.Api;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceResult;
import backtraceio.library.services.BacktraceHandlerInput;
import backtraceio.library.services.BacktraceHandlerInputEvents;
import backtraceio.library.services.BacktraceHandlerInputReport;
import backtraceio.library.services.BacktraceMetrics;
import backtraceio.library.services.BacktraceReportSender;
import backtraceio.library.services.SummedEventsHandler;
import backtraceio.library.services.UniqueEventsHandler;
import java.util.List;

public class BacktraceHandlerThread
extends HandlerThread {
    private static final transient String LOG_TAG = BacktraceHandlerThread.class.getSimpleName();
    private BacktraceHandler mHandler;
    private final String url;
    private UniqueEventsHandler mUniqueEventsHandler;
    private SummedEventsHandler mSummedEventsHandler;

    BacktraceHandlerThread(String name, String url) {
        super(name);
        this.url = url;
        this.start();
    }

    UniqueEventsHandler createUniqueEventsHandler(BacktraceMetrics backtraceMetrics, Api api) {
        this.mUniqueEventsHandler = new UniqueEventsHandler(backtraceMetrics, api, this);
        return this.mUniqueEventsHandler;
    }

    SummedEventsHandler createSummedEventsHandler(BacktraceMetrics backtraceMetrics, Api api) {
        this.mSummedEventsHandler = new SummedEventsHandler(backtraceMetrics, api, this);
        return this.mSummedEventsHandler;
    }

    protected void onLooperPrepared() {
        super.onLooperPrepared();
        if (this.mHandler == null) {
            this.mHandler = new BacktraceHandler(this.getLooper(), this.url);
        }
    }

    Message createMessage(BacktraceHandlerInput data) {
        Message message = new Message();
        message.obj = data;
        return message;
    }

    void sendReport(BacktraceHandlerInputReport data) {
        if (this.mHandler == null) {
            this.mHandler = new BacktraceHandler(this.getLooper(), this.url);
        }
        this.mHandler.sendMessage(this.createMessage(data));
    }

    void sendUniqueEvents(BacktraceHandlerInputEvents data) {
        this.mUniqueEventsHandler.sendMessage(this.createMessage(data));
    }

    void sendSummedEvents(BacktraceHandlerInputEvents data) {
        this.mSummedEventsHandler.sendMessage(this.createMessage(data));
    }

    private class BacktraceHandler
    extends Handler {
        private final transient String LOG_TAG;
        String url;

        private BacktraceHandler(Looper looper, String url) {
            super(looper);
            this.LOG_TAG = BacktraceHandler.class.getSimpleName();
            this.url = url;
        }

        public void handleMessage(Message msg) {
            BacktraceResult result;
            BacktraceHandlerInputReport mInput = (BacktraceHandlerInputReport)msg.obj;
            if (mInput.requestHandler != null) {
                BacktraceLogger.d(this.LOG_TAG, "Sending using custom request handler");
                result = mInput.requestHandler.onRequest(mInput.data);
            } else {
                BacktraceLogger.d(this.LOG_TAG, "Sending report using default request handler");
                String json = BacktraceSerializeHelper.toJson(mInput.data);
                List<String> attachments = mInput.data.getAttachments();
                result = BacktraceReportSender.sendReport(this.url, json, attachments, mInput.data.report, mInput.serverErrorEventListener);
            }
            if (mInput.serverResponseEventListener != null) {
                BacktraceLogger.d(this.LOG_TAG, "Processing result using custom event");
                mInput.serverResponseEventListener.onEvent(result);
            }
        }
    }
}

