/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import android.content.Context;
import backtraceio.library.enums.database.RetryOrder;
import backtraceio.library.interfaces.DatabaseContext;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceData;
import backtraceio.library.models.database.BacktraceDatabaseRecord;
import backtraceio.library.models.database.BacktraceDatabaseSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BacktraceDatabaseContext
implements DatabaseContext {
    private static final transient String LOG_TAG = BacktraceDatabaseContext.class.getSimpleName();
    private final String _path;
    private final int _retryNumber;
    private final Context _applicationContext;
    private final Map<Integer, List<BacktraceDatabaseRecord>> batchRetry = new HashMap<Integer, List<BacktraceDatabaseRecord>>();
    private long totalSize = 0L;
    private int totalRecords = 0;
    private final RetryOrder retryOrder;

    public BacktraceDatabaseContext(Context context, BacktraceDatabaseSettings settings) {
        this(context, settings.getDatabasePath(), settings.getRetryLimit(), settings.getRetryOrder());
    }

    private BacktraceDatabaseContext(Context context, String path, int retryNumber, RetryOrder retryOrder) {
        this._applicationContext = context;
        this._path = path;
        this._retryNumber = retryNumber;
        this.retryOrder = retryOrder;
        this.SetupBatch();
    }

    private void SetupBatch() {
        if (this._retryNumber == 0) {
            throw new IllegalArgumentException("Retry number must be greater than 0!");
        }
        for (int i = 0; i < this._retryNumber; ++i) {
            this.batchRetry.put(i, new ArrayList());
        }
    }

    @Override
    public BacktraceDatabaseRecord add(BacktraceData backtraceData) throws NullPointerException {
        BacktraceLogger.d(LOG_TAG, "Adding new record to database context");
        if (backtraceData == null) {
            BacktraceLogger.e(LOG_TAG, "BacktraceData is null");
            throw new NullPointerException("BacktraceData");
        }
        BacktraceDatabaseRecord record = new BacktraceDatabaseRecord(backtraceData, this._path);
        record.save();
        return this.add(record);
    }

    @Override
    public BacktraceDatabaseRecord add(BacktraceDatabaseRecord backtraceDatabaseRecord) {
        BacktraceLogger.d(LOG_TAG, "Adding new record to database context");
        if (backtraceDatabaseRecord == null) {
            BacktraceLogger.e(LOG_TAG, "Backtrace database record is null");
            throw new NullPointerException("BacktraceDatabaseRecord");
        }
        backtraceDatabaseRecord.locked = true;
        this.totalSize += backtraceDatabaseRecord.getSize();
        this.batchRetry.get(0).add(backtraceDatabaseRecord);
        ++this.totalRecords;
        return backtraceDatabaseRecord;
    }

    @Override
    public BacktraceDatabaseRecord first() {
        return this.retryOrder == RetryOrder.Queue ? this.getFirstRecord() : this.getLastRecord();
    }

    @Override
    public BacktraceDatabaseRecord last() {
        return this.retryOrder == RetryOrder.Queue ? this.getLastRecord() : this.getFirstRecord();
    }

    @Override
    public Iterable<BacktraceDatabaseRecord> get() {
        ArrayList<BacktraceDatabaseRecord> allRecords = new ArrayList<BacktraceDatabaseRecord>();
        for (Map.Entry<Integer, List<BacktraceDatabaseRecord>> entry : this.batchRetry.entrySet()) {
            allRecords.addAll((Collection<BacktraceDatabaseRecord>)entry.getValue());
        }
        return allRecords;
    }

    @Override
    public boolean delete(BacktraceDatabaseRecord record) {
        if (record == null) {
            return false;
        }
        for (int key : this.batchRetry.keySet()) {
            for (BacktraceDatabaseRecord databaseRecord : this.batchRetry.get(key)) {
                if (databaseRecord == null || record.id != databaseRecord.id) continue;
                databaseRecord.delete();
                this.batchRetry.get(key).remove(databaseRecord);
                --this.totalRecords;
                this.totalSize -= databaseRecord.getSize();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(BacktraceDatabaseRecord record) {
        if (record == null) {
            throw new NullPointerException("BacktraceDatabaseRecord");
        }
        for (Map.Entry<Integer, List<BacktraceDatabaseRecord>> entry : this.batchRetry.entrySet()) {
            List<BacktraceDatabaseRecord> records = entry.getValue();
            for (BacktraceDatabaseRecord databaseRecord : records) {
                if (databaseRecord == null || databaseRecord.id != record.id) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.totalRecords == 0;
    }

    @Override
    public int count() {
        return this.totalRecords;
    }

    @Override
    public void clear() {
        BacktraceLogger.d(LOG_TAG, "Deleting all records from database context");
        for (Map.Entry<Integer, List<BacktraceDatabaseRecord>> entry : this.batchRetry.entrySet()) {
            List<BacktraceDatabaseRecord> records = entry.getValue();
            for (BacktraceDatabaseRecord databaseRecord : records) {
                databaseRecord.delete();
            }
        }
        this.totalRecords = 0;
        this.totalSize = 0L;
        for (Map.Entry<Integer, List<BacktraceDatabaseRecord>> entry : this.batchRetry.entrySet()) {
            entry.getValue().clear();
        }
    }

    @Override
    public void incrementBatchRetry() {
        this.removeMaxRetries();
        this.incrementBatches();
    }

    @Override
    public long getDatabaseSize() {
        return this.totalSize;
    }

    @Override
    public boolean removeOldestRecord() {
        BacktraceLogger.d(LOG_TAG, "Removing oldest record from database context");
        BacktraceDatabaseRecord record = this.first();
        if (record == null) {
            BacktraceLogger.w(LOG_TAG, "Oldest record in database is null");
            return false;
        }
        return this.delete(record);
    }

    private void incrementBatches() {
        for (int i = this._retryNumber - 2; i >= 0; --i) {
            List<BacktraceDatabaseRecord> temp = this.batchRetry.get(i);
            this.batchRetry.put(i, new ArrayList());
            this.batchRetry.put(i + 1, temp);
        }
    }

    private void removeMaxRetries() {
        List<BacktraceDatabaseRecord> currentBatch = this.batchRetry.get(this._retryNumber - 1);
        for (BacktraceDatabaseRecord record : currentBatch) {
            if (!record.valid()) continue;
            record.delete();
            --this.totalRecords;
            this.totalSize -= record.getSize();
        }
    }

    private BacktraceDatabaseRecord getFirstRecord() {
        return this.getRecordFromCache(false);
    }

    private BacktraceDatabaseRecord getLastRecord() {
        return this.getRecordFromCache(true);
    }

    private BacktraceDatabaseRecord getRecordFromCache(boolean reverse) {
        for (int i = this._retryNumber - 1; i >= 0; --i) {
            List<BacktraceDatabaseRecord> reverseRecords = this.batchRetry.get(i);
            if (reverse) {
                Collections.reverse(reverseRecords);
            }
            for (BacktraceDatabaseRecord record : reverseRecords) {
                if (record.locked) continue;
                record.locked = true;
                return record;
            }
        }
        return null;
    }
}

