/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.json;

import backtraceio.library.models.BacktraceStackFrame;
import backtraceio.library.models.json.ThreadInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ThreadData {
    public HashMap<String, ThreadInformation> threadInformation = new HashMap();
    private String mainThread = "";

    public ThreadData(ArrayList<BacktraceStackFrame> exceptionStack) {
        this.generateCurrentThreadInformation(exceptionStack);
        this.processThreads();
    }

    public String getMainThread() {
        return this.mainThread;
    }

    private void generateCurrentThreadInformation(ArrayList<BacktraceStackFrame> exceptionStack) {
        Thread currThread = Thread.currentThread();
        this.mainThread = currThread.getName().toLowerCase();
        this.threadInformation.put(this.mainThread, new ThreadInformation(currThread, exceptionStack, true));
    }

    private void processThreads() {
        Map<Thread, StackTraceElement[]> myMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : myMap.entrySet()) {
            if (entry.getKey() == null) continue;
            Thread thread = entry.getKey();
            StackTraceElement[] stack = entry.getValue();
            String threadName = thread.getName().toLowerCase();
            ArrayList<BacktraceStackFrame> stackFrame = new ArrayList<BacktraceStackFrame>();
            if (this.getMainThread().equals(threadName)) continue;
            if (stack != null && stack.length != 0) {
                for (StackTraceElement stackTraceElement : stack) {
                    stackFrame.add(new BacktraceStackFrame(stackTraceElement));
                }
            }
            this.threadInformation.put(threadName, new ThreadInformation(thread, stackFrame, false));
        }
    }
}

