/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.json;

import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceStackFrame;
import backtraceio.library.models.json.SourceCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SourceCodeData {
    private static final transient String LOG_TAG = SourceCodeData.class.getSimpleName();
    public Map<String, SourceCode> data = new HashMap<String, SourceCode>();

    public SourceCodeData(ArrayList<BacktraceStackFrame> exceptionStack) {
        BacktraceLogger.d(LOG_TAG, "Initialization source code data");
        if (exceptionStack == null || exceptionStack.size() == 0) {
            BacktraceLogger.w(LOG_TAG, "Exception stack is null or empty");
            return;
        }
        for (BacktraceStackFrame backtraceStackFrame : exceptionStack) {
            if (backtraceStackFrame == null || backtraceStackFrame.sourceCode.equals("")) {
                BacktraceLogger.w(LOG_TAG, "Stack frame is null or sourceCode is empty");
                continue;
            }
            String id = backtraceStackFrame.sourceCode;
            SourceCode value = new SourceCode(backtraceStackFrame);
            this.data.put(id, value);
        }
    }
}

