/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.database;

import backtraceio.library.common.BacktraceSerializeHelper;
import backtraceio.library.interfaces.DatabaseRecordWriter;
import backtraceio.library.logger.BacktraceLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BacktraceDatabaseRecordWriter
implements DatabaseRecordWriter {
    private static final transient String LOG_TAG = BacktraceDatabaseRecordWriter.class.getSimpleName();
    private final String _destinationPath;

    public BacktraceDatabaseRecordWriter(String path) {
        this._destinationPath = path;
    }

    @Override
    public String write(Object data, String prefix) throws IOException {
        String json = this.toJsonFile(data);
        byte[] file = json.getBytes(StandardCharsets.UTF_8);
        return this.write(file, prefix);
    }

    @Override
    public String write(byte[] data, String prefix) throws IOException {
        String filename = String.format("%s.json", prefix);
        String tempFilePath = new File(this._destinationPath, String.format("temp_%s", filename)).getAbsolutePath();
        this.saveTemporaryFile(tempFilePath, data);
        String destFilePath = new File(this._destinationPath, filename).getAbsolutePath();
        this.saveValidRecord(tempFilePath, destFilePath);
        return destFilePath;
    }

    private String toJsonFile(Object data) {
        if (data == null) {
            BacktraceLogger.w(LOG_TAG, "Passed object to serialization is null");
            return "";
        }
        return BacktraceSerializeHelper.toJson(data);
    }

    private void saveValidRecord(String sourcePath, String destinationPath) throws IOException {
        File fromFile = new File(sourcePath);
        File toFile = new File(destinationPath);
        boolean renameResult = fromFile.renameTo(toFile);
        if (!renameResult) {
            BacktraceLogger.e(LOG_TAG, "Can not rename file");
            throw new IOException(String.format("Can not rename file. Source path: %s, destination path: %s", sourcePath, destinationPath));
        }
    }

    private void saveTemporaryFile(String path, byte[] file) throws IOException {
        BacktraceLogger.d(LOG_TAG, "Saving temporary file");
        FileOutputStream out = new FileOutputStream(path);
        out.write(file);
        out.close();
    }
}

