/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models;

import backtraceio.library.logger.BacktraceLogger;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;

public class BacktraceStackFrame {
    private static final transient String LOG_TAG = BacktraceStackFrame.class.getSimpleName();
    @SerializedName(value="funcName")
    public String functionName;
    @SerializedName(value="line")
    public Integer line = null;
    @SerializedName(value="sourceCode")
    public String sourceCode;
    public transient String sourceCodeFileName;

    public BacktraceStackFrame() {
    }

    public BacktraceStackFrame(StackTraceElement frame) {
        if (frame == null || frame.getMethodName() == null) {
            BacktraceLogger.w(LOG_TAG, "Frame or method name is null");
            return;
        }
        this.functionName = frame.getClassName() + "." + frame.getMethodName();
        this.sourceCodeFileName = frame.getFileName();
        this.sourceCode = UUID.randomUUID().toString();
        this.line = frame.getLineNumber() > 0 ? Integer.valueOf(frame.getLineNumber()) : null;
    }
}

