/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models;

import android.os.Looper;
import backtraceio.library.BacktraceClient;
import backtraceio.library.events.OnServerResponseEventListener;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.json.BacktraceReport;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class BacktraceExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final transient String LOG_TAG = BacktraceExceptionHandler.class.getSimpleName();
    private static Map<String, Object> customAttributes;
    private final Thread.UncaughtExceptionHandler rootHandler;
    private final CountDownLatch signal = new CountDownLatch(1);
    private final BacktraceClient client;

    private BacktraceExceptionHandler(BacktraceClient client) {
        BacktraceLogger.d(LOG_TAG, "BacktraceExceptionHandler initialization");
        this.client = client;
        this.rootHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static void setCustomAttributes(Map<String, Object> attributes) {
        customAttributes = attributes;
    }

    public static void enable(BacktraceClient client) {
        new BacktraceExceptionHandler(client);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        OnServerResponseEventListener callback = this.getCallbackToDefaultHandler(thread, throwable);
        if (throwable instanceof Exception) {
            BacktraceLogger.e(LOG_TAG, "Sending uncaught exception to Backtrace API", throwable);
            BacktraceReport report = new BacktraceReport((Exception)throwable, customAttributes);
            report.attributes.put("error.type", "Unhandled Exception");
            this.client.send(report, callback);
            BacktraceLogger.d(LOG_TAG, "Uncaught exception sent to Backtrace API");
        }
        BacktraceLogger.d(LOG_TAG, "Default uncaught exception handler");
        try {
            this.signal.await();
        }
        catch (Exception ex) {
            BacktraceLogger.e(LOG_TAG, "Exception during waiting for response", ex);
        }
    }

    private boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private OnServerResponseEventListener getCallbackToDefaultHandler(Thread thread, Throwable throwable) {
        return backtraceResult -> {
            BacktraceLogger.d(LOG_TAG, "Root handler event callback");
            this.rootHandler.uncaughtException(thread, throwable);
            this.signal.countDown();
        };
    }
}

