/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.common;

import backtraceio.library.common.BacktraceStringHelper;
import backtraceio.library.logger.BacktraceLogger;
import java.io.IOException;
import java.io.OutputStream;

public class RequestHelper {
    private static final transient String LOG_TAG = RequestHelper.class.getSimpleName();
    private static final String CRLF = "\r\n";
    private static final String ENCODING = "utf-8";

    public static String getContentType() {
        return "application/json";
    }

    public static void addJson(OutputStream outputStream, String json) throws IOException {
        if (BacktraceStringHelper.isNullOrEmpty(json)) {
            BacktraceLogger.w(LOG_TAG, "JSON is null or empty");
            return;
        }
        if (outputStream == null) {
            BacktraceLogger.w(LOG_TAG, "Output stream is null");
            return;
        }
        byte[] bytes = json.getBytes(ENCODING);
        outputStream.write(bytes);
    }

    public static void addEndOfRequest(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            BacktraceLogger.w(LOG_TAG, "Output stream is null");
            return;
        }
        outputStream.write(CRLF.getBytes());
    }
}

