/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.common;

import backtraceio.library.common.BacktraceStringHelper;
import backtraceio.library.common.FileHelper;
import backtraceio.library.logger.BacktraceLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.List;

public class MultiFormRequestHelper {
    private static final transient String LOG_TAG = MultiFormRequestHelper.class.getSimpleName();
    private static final String BOUNDARY = "*****";
    private static final String CRLF = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private static final String ENCODING = "utf-8";

    public static String getContentType() {
        return "multipart/form-data;boundary=*****";
    }

    public static void addEndOfRequest(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            BacktraceLogger.w(LOG_TAG, "Output stream is null");
            return;
        }
        outputStream.write("--*****--\r\n".getBytes());
    }

    public static void addJson(OutputStream outputStream, String json) throws IOException {
        if (BacktraceStringHelper.isNullOrEmpty(json)) {
            BacktraceLogger.w(LOG_TAG, "JSON is null or empty");
            return;
        }
        if (outputStream == null) {
            BacktraceLogger.w(LOG_TAG, "Output stream is null");
            return;
        }
        outputStream.write("--*****\r\n".getBytes());
        outputStream.write(MultiFormRequestHelper.getFileInfo("upload_file").getBytes());
        outputStream.write(CRLF.getBytes());
        byte[] bytes = json.getBytes(ENCODING);
        outputStream.write(bytes);
        outputStream.write(CRLF.getBytes());
    }

    public static void addFiles(OutputStream outputStream, List<String> attachments) throws IOException {
        if (attachments == null || outputStream == null) {
            BacktraceLogger.w(LOG_TAG, "Attachments or output stream is null");
            return;
        }
        for (String fileAbsolutePath : attachments) {
            MultiFormRequestHelper.addFile(outputStream, fileAbsolutePath);
        }
    }

    private static void addFile(OutputStream outputStream, String absolutePath) throws IOException {
        if (absolutePath == null || outputStream == null) {
            BacktraceLogger.w(LOG_TAG, "Absolute path or output stream is null");
            return;
        }
        String fileContentType = URLConnection.guessContentTypeFromName(FileHelper.getFileNameFromPath(absolutePath));
        outputStream.write("--*****\r\n".getBytes());
        outputStream.write(MultiFormRequestHelper.getFileInfo("attachment_" + FileHelper.getFileNameFromPath(absolutePath)).getBytes());
        outputStream.write(("Content-Type: " + fileContentType + CRLF).getBytes());
        outputStream.write(CRLF.getBytes());
        MultiFormRequestHelper.streamFile(outputStream, absolutePath);
        outputStream.write(CRLF.getBytes());
    }

    public static void streamFile(OutputStream outputStream, String absolutePath) throws IOException {
        int c;
        if (outputStream == null || absolutePath == null) {
            BacktraceLogger.w(LOG_TAG, "Absolute path or output stream is null");
            return;
        }
        FileInputStream fis = new FileInputStream(absolutePath);
        byte[] b = new byte[4096];
        while ((c = fis.read(b)) != -1) {
            outputStream.write(b, 0, c);
        }
    }

    private static String getFileInfo(String fileName) {
        return "Content-Disposition: form-data; name=\"" + fileName + "\";filename=\"" + fileName + "\"" + CRLF;
    }
}

