/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.breadcrumbs;

import backtraceio.library.logger.BacktraceLogger;
import com.squareup.tape.QueueFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;

public class BacktraceQueueFileHelper {
    private final String breadcrumbLogDirectory;
    private final QueueFile breadcrumbStore;
    private final String LOG_TAG = BacktraceQueueFileHelper.class.getSimpleName();
    private final int maxQueueFileSizeBytes;
    private final int minimumQueueFileSizeBytes = 4096;
    private final Method usedBytes;

    public BacktraceQueueFileHelper(String breadcrumbLogDirectory, int maxQueueFileSizeBytes) throws IOException, NoSuchMethodException {
        this.breadcrumbLogDirectory = breadcrumbLogDirectory;
        this.breadcrumbStore = new QueueFile(new File(this.breadcrumbLogDirectory));
        this.usedBytes = QueueFile.class.getDeclaredMethod("usedBytes", new Class[0]);
        this.usedBytes.setAccessible(true);
        this.maxQueueFileSizeBytes = maxQueueFileSizeBytes < 4096 ? 4096 : maxQueueFileSizeBytes;
    }

    public boolean add(byte[] bytes) {
        try {
            int breadcrumbLength = bytes.length;
            if (breadcrumbLength > 4096) {
                BacktraceLogger.e(this.LOG_TAG, "We should not have a breadcrumb this big, this is a bug!");
                return false;
            }
            int usedBytes = (Integer)this.usedBytes.invoke((Object)this.breadcrumbStore, new Object[0]);
            while (!this.breadcrumbStore.isEmpty() && usedBytes + breadcrumbLength > this.maxQueueFileSizeBytes) {
                this.breadcrumbStore.remove();
                usedBytes = (Integer)this.usedBytes.invoke((Object)this.breadcrumbStore, new Object[0]);
            }
            this.breadcrumbStore.add(bytes);
        }
        catch (Exception ex) {
            BacktraceLogger.w(this.LOG_TAG, "Exception: " + ex.getMessage() + "\nWhen adding breadcrumb: " + new String(bytes, StandardCharsets.UTF_8));
            return false;
        }
        return true;
    }

    public boolean clear() {
        try {
            this.breadcrumbStore.clear();
        }
        catch (Exception ex) {
            BacktraceLogger.w(this.LOG_TAG, "Exception: " + ex.getMessage() + "\nWhen clearing breadcrumbs");
            return false;
        }
        return true;
    }
}

