/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.breadcrumbs;

import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import backtraceio.library.breadcrumbs.BacktraceBreadcrumbs;
import backtraceio.library.enums.BacktraceBreadcrumbLevel;
import backtraceio.library.enums.BacktraceBreadcrumbType;
import java.util.HashMap;

public class BacktraceComponentListener
implements ComponentCallbacks2 {
    private final BacktraceBreadcrumbs backtraceBreadcrumbs;

    public BacktraceComponentListener(BacktraceBreadcrumbs backtraceBreadcrumbs) {
        this.backtraceBreadcrumbs = backtraceBreadcrumbs;
    }

    private String getMemoryWarningString(int level) {
        switch (level) {
            case 20: {
                return "TRIM MEMORY UI HIDDEN";
            }
            case 5: {
                return "TRIM MEMORY RUNNING MODERATE";
            }
            case 10: {
                return "TRIM MEMORY RUNNING LOW";
            }
            case 15: {
                return "TRIM MEMORY RUNNING CRITICAL";
            }
            case 40: {
                return "TRIM MEMORY BACKGROUND";
            }
            case 60: {
                return "TRIM MEMORY MODERATE";
            }
            case 80: {
                return "TRIM MEMORY COMPLETE";
            }
        }
        return "Generic memory warning";
    }

    private BacktraceBreadcrumbLevel getMemoryWarningLevel(int level) {
        switch (level) {
            case 5: 
            case 10: 
            case 40: {
                return BacktraceBreadcrumbLevel.ERROR;
            }
            case 15: 
            case 60: 
            case 80: {
                return BacktraceBreadcrumbLevel.FATAL;
            }
        }
        return BacktraceBreadcrumbLevel.WARNING;
    }

    public void onTrimMemory(int level) {
        String messageString = this.getMemoryWarningString(level);
        BacktraceBreadcrumbLevel breadcrumbLevel = this.getMemoryWarningLevel(level);
        this.backtraceBreadcrumbs.addBreadcrumb(messageString, BacktraceBreadcrumbType.SYSTEM, breadcrumbLevel);
    }

    private String stringifyOrientation(int orientation) {
        switch (orientation) {
            case 2: {
                return "landscape";
            }
            case 1: {
                return "portrait";
            }
        }
        return "unknown orientation";
    }

    public void onConfigurationChanged(Configuration newConfig) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String orientation = this.stringifyOrientation(newConfig.orientation);
        attributes.put("orientation", orientation);
        this.backtraceBreadcrumbs.addBreadcrumb("Configuration changed", attributes, BacktraceBreadcrumbType.SYSTEM, BacktraceBreadcrumbLevel.INFO);
    }

    public void onLowMemory() {
        this.backtraceBreadcrumbs.addBreadcrumb("Critical low memory warning!", BacktraceBreadcrumbType.SYSTEM, BacktraceBreadcrumbLevel.FATAL);
    }
}

