/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library;

import android.content.Context;
import backtraceio.library.BacktraceCredentials;
import backtraceio.library.BacktraceDatabase;
import backtraceio.library.base.BacktraceBase;
import backtraceio.library.events.OnServerResponseEventListener;
import backtraceio.library.interfaces.Database;
import backtraceio.library.models.database.BacktraceDatabaseSettings;
import backtraceio.library.models.json.BacktraceReport;
import backtraceio.library.watchdog.BacktraceANRWatchdog;
import backtraceio.library.watchdog.OnApplicationNotRespondingEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BacktraceClient
extends BacktraceBase {
    private BacktraceANRWatchdog anrWatchdog;

    public BacktraceClient(Context context, BacktraceCredentials credentials) {
        this(context, credentials, (Database)null);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, List<String> attachments) {
        this(context, credentials, (Database)null, attachments);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, Map<String, Object> attributes) {
        this(context, credentials, (Database)null, attributes);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, Map<String, Object> attributes, List<String> attachments) {
        this(context, credentials, (Database)null, attributes, attachments);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings) {
        this(context, credentials, new BacktraceDatabase(context, databaseSettings));
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings, List<String> attachments) {
        this(context, credentials, (Database)new BacktraceDatabase(context, databaseSettings), attachments);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings, Map<String, Object> attributes) {
        this(context, credentials, (Database)new BacktraceDatabase(context, databaseSettings), attributes);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings, Map<String, Object> attributes, List<String> attachments) {
        this(context, credentials, new BacktraceDatabase(context, databaseSettings), attributes, attachments);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, Database database) {
        this(context, credentials, database, new HashMap<String, Object>());
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, Database database, List<String> attachments) {
        this(context, credentials, database, null, attachments);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, Database database, Map<String, Object> attributes) {
        this(context, credentials, database, attributes, null);
    }

    public BacktraceClient(Context context, BacktraceCredentials credentials, Database database, Map<String, Object> attributes, List<String> attachments) {
        super(context, credentials, database, attributes, attachments);
    }

    public void send(String message) {
        this.send(message, null);
    }

    public void send(String message, OnServerResponseEventListener serverResponseEventListener) {
        super.send(new BacktraceReport(message), serverResponseEventListener);
    }

    public void send(Exception exception) {
        this.send(exception, null);
    }

    public void send(Exception exception, OnServerResponseEventListener serverResponseEventListener) {
        super.send(new BacktraceReport(exception), serverResponseEventListener);
    }

    @Override
    public void send(BacktraceReport report) {
        this.send(report, null);
    }

    @Override
    public void send(BacktraceReport report, OnServerResponseEventListener serverResponseEventListener) {
        super.send(report, serverResponseEventListener);
    }

    public void enableAnr() {
        this.anrWatchdog = new BacktraceANRWatchdog(this);
    }

    public void enableAnr(int timeout) {
        this.enableAnr(timeout, null);
    }

    public void enableAnr(int timeout, OnApplicationNotRespondingEvent onApplicationNotRespondingEvent) {
        this.enableAnr(timeout, onApplicationNotRespondingEvent, false);
    }

    public void enableAnr(int timeout, boolean debug) {
        this.enableAnr(timeout, null, debug);
    }

    public void enableAnr(int timeout, OnApplicationNotRespondingEvent onApplicationNotRespondingEvent, boolean debug) {
        this.anrWatchdog = new BacktraceANRWatchdog(this, timeout, debug);
        this.anrWatchdog.setOnApplicationNotRespondingEvent(onApplicationNotRespondingEvent);
    }

    public void disableAnr() {
        if (this.anrWatchdog != null && !this.anrWatchdog.isInterrupted()) {
            this.anrWatchdog.stopMonitoringAnr();
        }
    }
}

