/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack.ppm;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.unpack.ppm.Pointer;
import de.innosystec.unrar.unpack.ppm.State;

public class FreqData
extends Pointer {
    public static final int size = 6;

    public FreqData(byte[] mem) {
        super(mem);
    }

    public FreqData init(byte[] mem) {
        this.mem = mem;
        this.pos = 0;
        return this;
    }

    public int getSummFreq() {
        return Raw.readShortLittleEndian(this.mem, this.pos) & 0xFFFF;
    }

    public void setSummFreq(int summFreq) {
        Raw.writeShortLittleEndian(this.mem, this.pos, (short)summFreq);
    }

    public void incSummFreq(int dSummFreq) {
        Raw.incShortLittleEndian(this.mem, this.pos, dSummFreq);
    }

    public int getStats() {
        return Raw.readIntLittleEndian(this.mem, this.pos + 2);
    }

    public void setStats(State state) {
        this.setStats(state.getAddress());
    }

    public void setStats(int state) {
        Raw.writeIntLittleEndian(this.mem, this.pos + 2, state);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FreqData[");
        buffer.append("\n  pos=");
        buffer.append(this.pos);
        buffer.append("\n  size=");
        buffer.append(6);
        buffer.append("\n  summFreq=");
        buffer.append(this.getSummFreq());
        buffer.append("\n  stats=");
        buffer.append(this.getStats());
        buffer.append("\n]");
        return buffer.toString();
    }
}

