/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BlockHeader;
import de.innosystec.unrar.rarfile.FileNameDecoder;
import de.innosystec.unrar.rarfile.HostSystem;
import de.innosystec.unrar.rarfile.NewSubHeaderType;
import de.innosystec.unrar.rarfile.UnrarHeadertype;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileHeader
extends BlockHeader {
    private final Log logger = LogFactory.getLog((String)FileHeader.class.getName());
    private static final byte SALT_SIZE = 8;
    private static final byte NEWLHD_SIZE = 32;
    private long unpSize;
    private final HostSystem hostOS;
    private final int fileCRC;
    private final int fileTime;
    private byte unpVersion;
    private byte unpMethod;
    private short nameSize;
    private int highPackSize;
    private int highUnpackSize;
    private final byte[] fileNameBytes;
    private String fileName;
    private String fileNameW;
    private byte[] subData;
    private final byte[] salt = new byte[8];
    private Date mTime;
    private Date cTime;
    private Date aTime;
    private Date arcTime;
    private long fullPackSize;
    private long fullUnpackSize;
    private int fileAttr;
    private int subFlags;
    private int recoverySectors = -1;

    public FileHeader(BlockHeader bh, byte[] fileHeader) {
        super(bh);
        int i;
        int position = 0;
        this.unpSize = Raw.readIntLittleEndianAsLong(fileHeader, position);
        position += 4;
        this.hostOS = HostSystem.findHostSystem(fileHeader[4]);
        this.fileCRC = Raw.readIntLittleEndian(fileHeader, ++position);
        this.fileTime = Raw.readIntLittleEndian(fileHeader, position += 4);
        position += 4;
        this.unpVersion = (byte)(this.unpVersion | fileHeader[13] & 0xFF);
        ++position;
        this.unpMethod = (byte)(this.unpMethod | fileHeader[14] & 0xFF);
        this.nameSize = Raw.readShortLittleEndian(fileHeader, ++position);
        this.fileAttr = Raw.readIntLittleEndian(fileHeader, position += 2);
        position += 4;
        if (this.isLargeBlock()) {
            this.highPackSize = Raw.readIntLittleEndian(fileHeader, position);
            this.highUnpackSize = Raw.readIntLittleEndian(fileHeader, position += 4);
            position += 4;
        } else {
            this.highPackSize = 0;
            this.highUnpackSize = 0;
            if (this.unpSize == -1L) {
                this.unpSize = -1L;
                this.highUnpackSize = Integer.MAX_VALUE;
            }
        }
        this.fullPackSize |= (long)this.highPackSize;
        this.fullPackSize <<= 32;
        this.fullPackSize |= (long)this.getPackSize();
        this.fullUnpackSize |= (long)this.highUnpackSize;
        this.fullUnpackSize <<= 32;
        this.fullUnpackSize += this.unpSize;
        this.nameSize = (short)(this.nameSize > 4096 ? 4096 : (int)this.nameSize);
        this.fileNameBytes = new byte[this.nameSize];
        for (i = 0; i < this.nameSize; ++i) {
            this.fileNameBytes[i] = fileHeader[position];
            ++position;
        }
        if (this.isFileHeader()) {
            if (this.isUnicode()) {
                int length;
                this.fileName = "";
                this.fileNameW = "";
                for (length = 0; length < this.fileNameBytes.length && this.fileNameBytes[length] != 0; ++length) {
                }
                byte[] name = new byte[length];
                System.arraycopy(this.fileNameBytes, 0, name, 0, name.length);
                this.fileName = new String(name);
                if (length != this.nameSize) {
                    this.fileNameW = FileNameDecoder.decode(this.fileNameBytes, ++length);
                }
            } else {
                this.fileName = new String(this.fileNameBytes);
                this.fileNameW = "";
            }
        }
        if (UnrarHeadertype.NewSubHeader.equals(this.headerType)) {
            int datasize = this.headerSize - 32 - this.nameSize;
            if (this.hasSalt()) {
                datasize -= 8;
            }
            if (datasize > 0) {
                this.subData = new byte[datasize];
                for (int i2 = 0; i2 < datasize; ++i2) {
                    this.subData[i2] = fileHeader[position];
                    ++position;
                }
            }
            if (NewSubHeaderType.SUBHEAD_TYPE_RR.byteEquals(this.fileNameBytes)) {
                this.recoverySectors = this.subData[8] + (this.subData[9] << 8) + (this.subData[10] << 16) + (this.subData[11] << 24);
            }
        }
        if (this.hasSalt()) {
            for (i = 0; i < 8; ++i) {
                this.salt[i] = fileHeader[position];
                ++position;
            }
        }
        this.mTime = this.getDateDos(this.fileTime);
    }

    public void print() {
        super.print();
        StringBuilder str = new StringBuilder();
        str.append("unpSize: " + this.getUnpSize());
        str.append("\nHostOS: " + this.hostOS.name());
        str.append("\nMDate: " + this.mTime);
        str.append("\nFileName: " + this.getFileNameString());
        str.append("\nunpMethod: " + Integer.toHexString(this.getUnpMethod()));
        str.append("\nunpVersion: " + Integer.toHexString(this.getUnpVersion()));
        str.append("\nfullpackedsize: " + this.getFullPackSize());
        str.append("\nfullunpackedsize: " + this.getFullUnpackSize());
        str.append("\nisEncrypted: " + this.isEncrypted());
        str.append("\nisfileHeader: " + this.isFileHeader());
        str.append("\nisSolid: " + this.isSolid());
        str.append("\nisSplitafter: " + this.isSplitAfter());
        str.append("\nisSplitBefore:" + this.isSplitBefore());
        str.append("\nunpSize: " + this.getUnpSize());
        str.append("\ndataSize: " + this.getDataSize());
        str.append("\nisUnicode: " + this.isUnicode());
        str.append("\nhasVolumeNumber: " + this.hasVolumeNumber());
        str.append("\nhasArchiveDataCRC: " + this.hasArchiveDataCRC());
        str.append("\nhasSalt: " + this.hasSalt());
        str.append("\nhasEncryptVersions: " + this.hasEncryptVersion());
        str.append("\nisSubBlock: " + this.isSubBlock());
        this.logger.info((Object)str.toString());
    }

    private Date getDateDos(int time) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (time >>> 25) + 1980);
        cal.set(2, (time >>> 21 & 0xF) - 1);
        cal.set(5, time >>> 16 & 0x1F);
        cal.set(11, time >>> 11 & 0x1F);
        cal.set(12, time >>> 5 & 0x3F);
        cal.set(13, (time & 0x1F) * 2);
        return cal.getTime();
    }

    public Date getArcTime() {
        return this.arcTime;
    }

    public void setArcTime(Date arcTime) {
        this.arcTime = arcTime;
    }

    public Date getATime() {
        return this.aTime;
    }

    public void setATime(Date time) {
        this.aTime = time;
    }

    public Date getCTime() {
        return this.cTime;
    }

    public void setCTime(Date time) {
        this.cTime = time;
    }

    public int getFileAttr() {
        return this.fileAttr;
    }

    public void setFileAttr(int fileAttr) {
        this.fileAttr = fileAttr;
    }

    public int getFileCRC() {
        return this.fileCRC;
    }

    public byte[] getFileNameByteArray() {
        return this.fileNameBytes;
    }

    public String getFileNameString() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileNameW() {
        return this.fileNameW;
    }

    public void setFileNameW(String fileNameW) {
        this.fileNameW = fileNameW;
    }

    public int getHighPackSize() {
        return this.highPackSize;
    }

    public int getHighUnpackSize() {
        return this.highUnpackSize;
    }

    public HostSystem getHostOS() {
        return this.hostOS;
    }

    public Date getMTime() {
        return this.mTime;
    }

    public void setMTime(Date time) {
        this.mTime = time;
    }

    public short getNameSize() {
        return this.nameSize;
    }

    public int getRecoverySectors() {
        return this.recoverySectors;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getSubData() {
        return this.subData;
    }

    public int getSubFlags() {
        return this.subFlags;
    }

    public byte getUnpMethod() {
        return this.unpMethod;
    }

    public long getUnpSize() {
        return this.unpSize;
    }

    public byte getUnpVersion() {
        return this.unpVersion;
    }

    public long getFullPackSize() {
        return this.fullPackSize;
    }

    public long getFullUnpackSize() {
        return this.fullUnpackSize;
    }

    public String toString() {
        return super.toString();
    }

    public boolean isSplitAfter() {
        return (this.flags & 2) != 0;
    }

    public boolean isSplitBefore() {
        return (this.flags & 1) != 0;
    }

    public boolean isSolid() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isEncrypted() {
        return (this.flags & 4) != 0;
    }

    public boolean isUnicode() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isFileHeader() {
        return UnrarHeadertype.FileHeader.equals(this.headerType);
    }

    public boolean hasSalt() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isLargeBlock() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isDirectory() {
        return (this.flags & 0xE0) == 224;
    }
}

