package cn.org.atool.generator.javafile.template;

import cn.org.atool.generator.database.model.TableSetter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;

import static cn.org.atool.generator.javafile.template.DaoImplementFile.JavaDoc;
import static cn.org.atool.generator.util.ClassNames.FM_IBaseDao;

/**
 * dao interface代码生成构造
 *
 * @author wudarui
 */
public class DaoInterfaceFile extends AbstractTemplateFile {
    public DaoInterfaceFile(TableSetter table) {
        super(table);
        this.packageName = daoPackage(table);
        this.klassName = daoClass(table);
    }

    public static ClassName daoInterfaceName(TableSetter table) {
        return ClassName.get(daoPackage(table), daoClass(table));
    }

    public static String daoPackage(TableSetter table) {
        return table.gc().getBasePackage() + ".dao.intf";
    }

    public static String daoClass(TableSetter table) {
        return table.getEntityPrefix() + "Dao";
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addSuperinterface(parameterizedType(FM_IBaseDao, EntityFile.entityName(table)))
            .addJavadoc("$T: 数据操作接口\n", super.className())
            .addJavadoc("$L", JavaDoc)
            .addJavadoc("@author Powered By Fluent Mybatis");
    }

    @Override
    protected boolean isInterface() {
        return true;
    }
}