package cn.org.atool.generator.database;

import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.javafile.TemplateGenerator;
import org.mybatis.generator.api.JavaTypeResolver;

import java.util.function.Consumer;

/**
 * ITableConfig
 *
 * @author darui.wu Created by darui.wu on 2020/5/27.
 */
public interface ITableConfig {
    /**
     * 设置要生成的表
     *
     * @param consumer Consumer
     * @return ITableConfig
     */
    ITableConfig tables(Consumer<ITableConfigSet> consumer);

    /**
     * 设置表关联关系
     *
     * @param consumer Consumer
     * @return ITableConfig
     */
    ITableConfig relations(Consumer<TableConfigSet> consumer);

    /**
     * 执行生成
     */
    void execute();
}