package cn.org.atool.generator;

import cn.org.atool.generator.database.config.impl.ColumnConfig;
import cn.org.atool.generator.javafile.AnnotationGenerator;
import cn.org.atool.generator.javafile.TemplateGenerator;
import org.mybatis.generator.api.JavaTypeResolver;

import javax.sql.DataSource;

/**
 * Entity文件生成器
 *
 * @author wudarui
 */
@SuppressWarnings({"rawtypes", "unused"})
public class FileGenerator {
    /**
     * 单独设置字段类型和属性
     *
     * @param table  字段所属表, * 表示任意表
     * @param column 数据库字段名称
     * @param field  对应的Entity属性名称
     * @return ColumnConfig更详细的设置
     */
    public static ColumnConfig setColumn(String table, String column, String field) {
        return ColumnConfig.set(table, column, field);
    }

    /**
     * 根据class上的注解生成文件
     * <p>
     * 无法通过url, username, password方式指定数据源的场景适用
     *
     * @param dataSource 通过编码方式构造DataSource方式
     * @param classes    Class
     */
    public static void build(DataSource dataSource, Class... classes) {
        build(dataSource, null, classes);
    }

    /**
     * 根据class上的注解生成文件
     * <p>
     * 根据@Tables上是否设置了 srcDir 来判断是否生成配套的test辅助类
     * 根据@Tables上是否设置了 testDir 来判断是否生成配套的test辅助类
     *
     * @param classes Class
     */
    public static void build(Class... classes) {
        build(null, null, classes);
    }

    /**
     * 根据class上的注解生成文件
     * <p>
     * 无法通过url, username, password方式指定数据源的场景适用
     *
     * @param dataSource       通过编码方式构造DataSource方式
     * @param javaTypeResolver JavaTypeResolver
     * @param classes          Class
     */
    public static void build(DataSource dataSource, JavaTypeResolver javaTypeResolver, Class... classes) {
        for (Class clazz : classes) {
            AnnotationGenerator.generate(dataSource, javaTypeResolver, clazz);
        }
        if (TemplateGenerator.withTest) {
            TemplateGenerator.generateSummary();
        }
    }
}