/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin.util;

import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchema;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchemaKt;
import com.apollographql.apollo3.compiler.introspection.Introspection_to_schemaKt;
import com.apollographql.apollo3.compiler.introspection.Schema_to_introspectionKt;
import com.github.aoudiamoncef.apollo.plugin.config.CompilationUnit;
import com.github.aoudiamoncef.apollo.plugin.config.CompilerParams;
import com.github.aoudiamoncef.apollo.plugin.config.Introspection;
import com.github.aoudiamoncef.apollo.plugin.config.Service;
import com.github.aoudiamoncef.apollo.plugin.util.BuildDirLayout;
import com.github.aoudiamoncef.apollo.plugin.util.ConfigUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0013J%\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0015J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ)\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J7\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0000\u00a2\u0006\u0002\b'J;\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0000\u00a2\u0006\u0002\b,J\n\u0010-\u001a\u00020\u001c*\u00020\u0019\u00a8\u0006."}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/util/ConfigUtils;", "", "()V", "checkCompilationUnit", "Lcom/github/aoudiamoncef/apollo/plugin/config/CompilationUnit;", "project", "Lorg/apache/maven/project/MavenProject;", "serviceName", "", "compilationUnit", "checkCompilationUnit$apollo_client_maven_plugin", "checkCompilerParams", "Lcom/github/aoudiamoncef/apollo/plugin/config/CompilerParams;", "service", "Lcom/github/aoudiamoncef/apollo/plugin/config/Service;", "compilerParams", "checkCompilerParams$apollo_client_maven_plugin", "checkIntrospection", "Lcom/github/aoudiamoncef/apollo/plugin/config/Introspection;", "checkIntrospection$apollo_client_maven_plugin", "checkService", "checkService$apollo_client_maven_plugin", "convert", "", "from", "Ljava/io/File;", "to", "prettyPrint", "", "findFilesByMatcher", "", "files", "matcher", "Ljava/nio/file/PathMatcher;", "findFilesByMatcher$apollo_client_maven_plugin", "getSourceSetFiles", "sourceFolder", "includes", "excludes", "getSourceSetFiles$apollo_client_maven_plugin", "resolveSchema", "schemaPath", "directories", "sourceSetFiles", "resolveSchema$apollo_client_maven_plugin", "isIntrospection", "apollo-client-maven-plugin"})
@SourceDebugExtension(value={"SMAP\nConfigUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigUtils.kt\ncom/github/aoudiamoncef/apollo/plugin/util/ConfigUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 moshi.kt\ncom/apollographql/apollo3/compiler/MoshiKt\n*L\n1#1,217:1\n37#2,2:218\n37#2,2:220\n1360#3:222\n1446#3,5:223\n1549#3:228\n1620#3,3:229\n60#4,3:232\n17#4:235\n*S KotlinDebug\n*F\n+ 1 ConfigUtils.kt\ncom/github/aoudiamoncef/apollo/plugin/util/ConfigUtils\n*L\n146#1:218,2\n147#1:220,2\n186#1:222\n186#1:223,5\n195#1:228\n195#1:229,3\n213#1:232,3\n213#1:235\n*E\n"})
public final class ConfigUtils {
    @NotNull
    public static final ConfigUtils INSTANCE = new ConfigUtils();

    private ConfigUtils() {
    }

    @NotNull
    public final Service checkService$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull String serviceName, @NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        service.setIntrospection$apollo_client_maven_plugin(service.isIntrospectionInitialised() ? service.getIntrospection$apollo_client_maven_plugin() : new Introspection());
        service.setCompilationUnit$apollo_client_maven_plugin(service.isCompilationUnitInitialised() ? service.getCompilationUnit$apollo_client_maven_plugin() : new CompilationUnit());
        if (service.getSourceFolder$apollo_client_maven_plugin() == null) {
            String compilationUnitName = !StringsKt.isBlank((CharSequence)service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin()) ? service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin() : serviceName;
            File sourceFolder = new File(project.getBasedir() + "/src/main/graphql/" + compilationUnitName);
            sourceFolder.getParentFile().mkdirs();
            service.setSourceFolder$apollo_client_maven_plugin(sourceFolder);
        }
        return service;
    }

    @NotNull
    public final CompilationUnit checkCompilationUnit$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull String serviceName, @NotNull CompilationUnit compilationUnit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)compilationUnit, (String)"compilationUnit");
        compilationUnit.setCompilerParams$apollo_client_maven_plugin(compilationUnit.isCompilationparamsInitialised() ? compilationUnit.getCompilerParams$apollo_client_maven_plugin() : new CompilerParams());
        if (StringsKt.isBlank((CharSequence)compilationUnit.getName$apollo_client_maven_plugin())) {
            compilationUnit.setName$apollo_client_maven_plugin(serviceName);
        }
        if (compilationUnit.getGenerateOperationDescriptors$apollo_client_maven_plugin()) {
            if (compilationUnit.getOperationOutputFile$apollo_client_maven_plugin() == null) {
                File operationOuput = BuildDirLayout.INSTANCE.operationOuput$apollo_client_maven_plugin(project, compilationUnit);
                operationOuput.getParentFile().mkdirs();
                operationOuput.createNewFile();
                compilationUnit.setOperationOutputFile$apollo_client_maven_plugin(operationOuput);
            } else {
                File file = compilationUnit.getOperationOutputFile$apollo_client_maven_plugin();
                if (file != null && (file = file.getParentFile()) != null) {
                    file.mkdirs();
                }
                File file2 = compilationUnit.getOperationOutputFile$apollo_client_maven_plugin();
                if (file2 != null) {
                    file2.createNewFile();
                }
            }
        } else {
            compilationUnit.setOperationOutputFile$apollo_client_maven_plugin(null);
        }
        if (compilationUnit.getOutputDirectory$apollo_client_maven_plugin() == null) {
            compilationUnit.setOutputDirectory$apollo_client_maven_plugin(BuildDirLayout.INSTANCE.sources$apollo_client_maven_plugin(project, compilationUnit));
        }
        if (compilationUnit.getDebugDirectory$apollo_client_maven_plugin() == null) {
            compilationUnit.setDebugDirectory$apollo_client_maven_plugin(BuildDirLayout.INSTANCE.debug$apollo_client_maven_plugin(project, compilationUnit));
        }
        if (compilationUnit.getTestDirectory$apollo_client_maven_plugin() == null) {
            compilationUnit.setTestDirectory$apollo_client_maven_plugin(BuildDirLayout.INSTANCE.test$apollo_client_maven_plugin(project, compilationUnit));
        }
        return compilationUnit;
    }

    @NotNull
    public final Introspection checkIntrospection$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Introspection introspection = service.getIntrospection$apollo_client_maven_plugin();
        if (introspection.getEnabled$apollo_client_maven_plugin()) {
            if (StringsKt.isBlank((CharSequence)introspection.getEndpointUrl$apollo_client_maven_plugin())) {
                throw new MojoExecutionException("introspection: must have a url");
            }
            if (introspection.getSchemaFile$apollo_client_maven_plugin() == null) {
                if (!StringsKt.isBlank((CharSequence)service.getSchemaPath$apollo_client_maven_plugin())) {
                    File schemaFile = new File(service.getSchemaPath$apollo_client_maven_plugin());
                    schemaFile.getParentFile().mkdirs();
                    schemaFile.createNewFile();
                    introspection.setSchemaFile$apollo_client_maven_plugin(schemaFile);
                } else {
                    File schemaFile = new File(project.getBasedir() + "/src/main/graphql/" + service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin() + "/schema.json");
                    schemaFile.getParentFile().mkdirs();
                    schemaFile.createNewFile();
                    introspection.setSchemaFile$apollo_client_maven_plugin(schemaFile);
                }
            }
        }
        return introspection;
    }

    @NotNull
    public final CompilerParams checkCompilerParams$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull Service service, @NotNull CompilerParams compilerParams) {
        CharSequence charSequence;
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)compilerParams, (String)"compilerParams");
        if (!((Collection)compilerParams.getRootFolders$apollo_client_maven_plugin()).isEmpty()) {
            list = compilerParams.getRootFolders$apollo_client_maven_plugin();
        } else {
            File file = service.getSourceFolder$apollo_client_maven_plugin();
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type java.io.File");
            list = CollectionsKt.listOf((Object)file);
        }
        compilerParams.setRootFolders$apollo_client_maven_plugin(list);
        if (compilerParams.getMetadataOutputFile$apollo_client_maven_plugin() == null) {
            compilerParams.setMetadataOutputFile$apollo_client_maven_plugin(BuildDirLayout.INSTANCE.metadata$apollo_client_maven_plugin(project, service.getCompilationUnit$apollo_client_maven_plugin()));
        }
        if (compilerParams.getGenerateApolloMetadata$apollo_client_maven_plugin() && compilerParams.getAlwaysGenerateTypesMatching$apollo_client_maven_plugin().isEmpty()) {
            compilerParams.setAlwaysGenerateTypesMatching$apollo_client_maven_plugin(SetsKt.setOf((Object)".*"));
        }
        if ((charSequence = (CharSequence)compilerParams.getPackageName$apollo_client_maven_plugin()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if (!StringsKt.isBlank((CharSequence)compilerParams.getSchemaPackageName$apollo_client_maven_plugin())) {
                compilerParams.setPackageName$apollo_client_maven_plugin(StringsKt.removeSuffix((String)compilerParams.getSchemaPackageName$apollo_client_maven_plugin(), (CharSequence)"schema") + "operation");
            } else {
                compilerParams.setPackageName$apollo_client_maven_plugin(project.getGroupId() + ".apollo.client." + service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin() + ".operation");
            }
        }
        if (StringsKt.isBlank((CharSequence)compilerParams.getSchemaPackageName$apollo_client_maven_plugin())) {
            compilerParams.setSchemaPackageName$apollo_client_maven_plugin(project.getGroupId() + ".apollo.client." + service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin() + ".schema");
        }
        return compilerParams;
    }

    @NotNull
    public final Set<File> findFilesByMatcher$apollo_client_maven_plugin(@NotNull Set<? extends File> files, @NotNull PathMatcher matcher) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)((Function1)new Function1<File, Boolean>(matcher){
            final /* synthetic */ PathMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.$matcher.matches(file.toPath());
            }
        })));
    }

    @NotNull
    public final Set<File> getSourceSetFiles$apollo_client_maven_plugin(@NotNull File sourceFolder, @NotNull Set<String> includes, @NotNull Set<String> excludes) {
        DirectoryScanner directoryScanner;
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        DirectoryScanner $this$getSourceSetFiles_u24lambda_u240 = directoryScanner = new DirectoryScanner();
        boolean bl = false;
        $this$getSourceSetFiles_u24lambda_u240.setBasedir(sourceFolder);
        $this$getSourceSetFiles_u24lambda_u240.setCaseSensitive(false);
        Collection $this$toTypedArray$iv = includes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$getSourceSetFiles_u24lambda_u240.setIncludes(thisCollection$iv.toArray(new String[0]));
        $this$toTypedArray$iv = excludes;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$getSourceSetFiles_u24lambda_u240.addExcludes(thisCollection$iv.toArray(new String[0]));
        $this$getSourceSetFiles_u24lambda_u240.scan();
        DirectoryScanner scanner = directoryScanner;
        String[] stringArray = scanner.getIncludedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"scanner.includedFiles");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])stringArray), (Function1)((Function1)new Function1<String, File>(sourceFolder){
            final /* synthetic */ File $sourceFolder;
            {
                this.$sourceFolder = $sourceFolder;
                super(1);
            }

            public final File invoke(String path) {
                String[] stringArray = new String[]{path};
                return Paths.get(this.$sourceFolder.getPath(), stringArray).toFile();
            }
        })), (Function1)getSourceSetFiles.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File resolveSchema$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull String schemaPath, @NotNull Set<? extends File> directories, @NotNull Set<? extends File> sourceSetFiles) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        Intrinsics.checkNotNullParameter(sourceSetFiles, (String)"sourceSetFiles");
        if (!StringsKt.isBlank((CharSequence)schemaPath)) {
            if (FilesKt.isRooted((File)new File(schemaPath))) {
                return new File(schemaPath);
            }
            if (StringsKt.startsWith$default((String)schemaPath, (String)"..", (boolean)false, (int)2, null)) {
                return FilesKt.normalize((File)new File(project.getBasedir() + "/src/main/graphql/" + schemaPath));
            }
            if (!(sourceSetFiles.size() <= 1)) {
                boolean $i$a$-require-ConfigUtils$resolveSchema$42 = false;
                String $i$a$-require-ConfigUtils$resolveSchema$42 = "ApolloGraphQL: duplicate(s) schema file(s) found:\n" + CollectionsKt.joinToString$default((Iterable)sourceSetFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)resolveSchema.1.1.INSTANCE, (int)30, null);
                throw new IllegalArgumentException($i$a$-require-ConfigUtils$resolveSchema$42.toString());
            }
            if (!(sourceSetFiles.size() == 1)) {
                boolean $i$a$-require-ConfigUtils$resolveSchema$52 = false;
                String $i$a$-require-ConfigUtils$resolveSchema$52 = "ApolloGraphQL: cannot find a schema file at " + schemaPath + ". Tried:\n" + CollectionsKt.joinToString$default((Iterable)sourceSetFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)resolveSchema.2.1.INSTANCE, (int)30, null);
                throw new IllegalArgumentException($i$a$-require-ConfigUtils$resolveSchema$52.toString());
            }
            return (File)CollectionsKt.first((Iterable)sourceSetFiles);
        }
        Iterable $this$flatMap$iv = directories;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File srcDir = (File)element$iv$iv;
            boolean bl = false;
            list$iv$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)srcDir)), (Function1)resolveSchema.candidates.1.1.INSTANCE));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List candidates2 = (List)destination$iv$iv;
        if (!(candidates2.size() <= 1)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            $this$flatMapTo$iv$iv = candidates2;
            StringBuilder stringBuilder = new StringBuilder().append("duplicate Schema : ");
            boolean $i$f$map = false;
            list$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it);
            }
            String string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString();
            throw new MojoExecutionException(string);
        }
        return (File)CollectionsKt.firstOrNull((List)candidates2);
    }

    public final boolean isIntrospection(@NotNull File $this$isIntrospection) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntrospection, (String)"<this>");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$isIntrospection), (Object)"json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convert(@NotNull File from, @NotNull File to, boolean prettyPrint) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (this.isIntrospection(from)) {
            GqlnodeKt.toUtf8$default((GQLNode)((GQLNode)Introspection_to_schemaKt.toGQLDocument$default((IntrospectionSchema)IntrospectionSchemaKt.toIntrospectionSchema((File)from), null, (int)1, null)), (File)to, null, (int)2, null);
        } else {
            IntrospectionSchema $this$toJson_u24default$iv = Schema_to_introspectionKt.toIntrospectionSchema((Schema)Introspection_to_schemaKt.toSchema((File)from));
            String indent$iv = "";
            boolean $i$f$toJson = false;
            Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink((OutputStream)new FileOutputStream(to)));
            Throwable throwable = null;
            try {
                BufferedSink it$iv = (BufferedSink)closeable;
                boolean bl = false;
                boolean $i$f$getJsonAdapter = false;
                MoshiKt.getMOSHI().adapter(IntrospectionSchema.class).indent(indent$iv).toJson(it$iv, (Object)$this$toJson_u24default$iv);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

