/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.keys;

import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import com.github.alkedr.matchers.reporting.sub.value.keys.MethodNameUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;

class MethodKey
implements Key {
    private final Method method;
    private final Object[] arguments;

    MethodKey(Method method, Object ... arguments) {
        Validate.notNull((Object)method, (String)"method", (Object[])new Object[0]);
        Validate.notNull((Object)arguments, (String)"arguments", (Object[])new Object[0]);
        this.method = method;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodKey methodKey = (MethodKey)o;
        return this.method.equals(methodKey.method) && Arrays.equals(this.arguments, methodKey.arguments);
    }

    @Override
    public int hashCode() {
        return 31 * this.method.hashCode() + Arrays.hashCode(this.arguments);
    }

    @Override
    public String asString() {
        return MethodNameUtils.createNameForRegularMethodInvocation(this.method.getName(), this.arguments);
    }
}

