/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.keys;

import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import com.github.alkedr.matchers.reporting.sub.value.keys.MethodNameUtils;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;

class MethodByNameKey
implements Key {
    private final String methodName;
    private final Object[] arguments;

    MethodByNameKey(String methodName, Object ... arguments) {
        Validate.notNull((Object)methodName, (String)"methodName", (Object[])new Object[0]);
        Validate.notNull((Object)arguments, (String)"arguments", (Object[])new Object[0]);
        this.methodName = methodName;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodByNameKey that = (MethodByNameKey)o;
        return this.methodName.equals(that.methodName) && Arrays.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        return 31 * this.methodName.hashCode() + Arrays.hashCode(this.arguments);
    }

    @Override
    public String asString() {
        return MethodNameUtils.createNameForRegularMethodInvocation(this.methodName, this.arguments);
    }
}

