/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import org.apache.commons.lang3.Validate;

class RenamedExtractor<T, S>
implements SubValuesExtractor<T, S> {
    private final SubValuesExtractor<T, S> originalExtractor;
    private final String name;

    RenamedExtractor(SubValuesExtractor<T, S> originalExtractor, String name) {
        Validate.notNull(originalExtractor, (String)"originalExtractor", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)name, (String)"name", (Object[])new Object[0]);
        this.originalExtractor = originalExtractor;
        this.name = name;
    }

    @Override
    public void run(T item, SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        this.originalExtractor.run(item, new KeyRenamingSubValuesListener<S>(subValuesListener, this.name));
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        this.originalExtractor.runForAbsentItem(new KeyRenamingSubValuesListener<S>(subValuesListener, this.name));
    }

    private static class KeyRenamingSubValuesListener<S>
    implements SubValuesExtractor.SubValuesListener<S> {
        private final SubValuesExtractor.SubValuesListener<S> originalSubValuesListener;
        private final String name;

        KeyRenamingSubValuesListener(SubValuesExtractor.SubValuesListener<S> originalSubValuesListener, String name) {
            this.originalSubValuesListener = originalSubValuesListener;
            this.name = name;
        }

        @Override
        public void present(Key key, S value) {
            this.originalSubValuesListener.present(Keys.renamedKey(key, this.name), value);
        }

        @Override
        public void absent(Key key) {
            this.originalSubValuesListener.absent(Keys.renamedKey(key, this.name));
        }

        @Override
        public void broken(Key key, Throwable throwable) {
            this.originalSubValuesListener.broken(Keys.renamedKey(key, this.name), throwable);
        }
    }
}

