/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.Validate;

class MethodExtractor<T, S>
implements SubValuesExtractor<T, S> {
    private final Method method;
    private final Object[] arguments;

    MethodExtractor(Method method, Object ... arguments) {
        Validate.notNull((Object)method, (String)"method", (Object[])new Object[0]);
        Validate.notNull((Object)arguments, (String)"arguments", (Object[])new Object[0]);
        this.method = method;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public void run(T item, SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        if (item == null && !Modifier.isStatic(this.method.getModifiers())) {
            subValuesListener.absent(Keys.methodKey(this.method, this.arguments));
        } else {
            try {
                this.method.setAccessible(true);
                subValuesListener.present(Keys.methodKey(this.method, this.arguments), this.method.invoke(item, this.arguments));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                subValuesListener.broken(Keys.methodKey(this.method, this.arguments), e);
            }
            catch (InvocationTargetException e) {
                subValuesListener.broken(Keys.methodKey(this.method, this.arguments), e.getCause());
            }
        }
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        this.run(null, subValuesListener);
    }
}

