/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractors;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;

class MethodByNameExtractor<T, S>
implements SubValuesExtractor<T, S> {
    private final String methodName;
    private final Object[] arguments;

    MethodByNameExtractor(String methodName, Object ... arguments) {
        Validate.notNull((Object)methodName, (String)"methodName", (Object[])new Object[0]);
        Validate.notNull((Object)arguments, (String)"arguments", (Object[])new Object[0]);
        this.methodName = methodName;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public void run(T item, SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        if (item == null) {
            subValuesListener.absent(Keys.methodByNameKey(this.methodName, this.arguments));
        } else {
            Method method = MethodUtils.getMatchingAccessibleMethod(item.getClass(), (String)this.methodName, (Class[])ClassUtils.toClass((Object[])this.arguments));
            if (method == null) {
                subValuesListener.broken(Keys.methodByNameKey(this.methodName, this.arguments), new NoSuchMethodException(item.getClass().getName() + "." + this.toString()));
            } else {
                SubValuesExtractors.method(method, this.arguments).run(item, subValuesListener);
            }
        }
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<S> subValuesListener) {
        subValuesListener.absent(Keys.methodByNameKey(this.methodName, this.arguments));
    }
}

