/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.extractors;

import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.keys.Keys;
import java.util.Iterator;

public class IterableElementExtractor<T>
implements SubValuesExtractor<Iterable<T>, T> {
    private final int index;

    public IterableElementExtractor(int index) {
        this.index = index;
    }

    @Override
    public void run(Iterable<T> item, SubValuesExtractor.SubValuesListener<T> subValuesListener) {
        Iterator<T> iterator = item.iterator();
        int currentIndex = 0;
        while (iterator.hasNext()) {
            T currentElement = iterator.next();
            if (currentIndex != this.index) continue;
            subValuesListener.present(Keys.elementKey(this.index), currentElement);
            return;
        }
        subValuesListener.absent(Keys.elementKey(this.index));
    }

    @Override
    public void runForAbsentItem(SubValuesExtractor.SubValuesListener<T> subValuesListener) {
        subValuesListener.absent(Keys.elementKey(this.index));
    }
}

