/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.sub.value.checkers;

import com.github.alkedr.matchers.reporting.reporters.SafeTreeReporter;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

class CompositeSubValuesChecker
implements SubValuesChecker {
    private final Iterable<SubValuesChecker> subValuesCheckers;

    CompositeSubValuesChecker(Iterable<SubValuesChecker> subValuesCheckers) {
        this.subValuesCheckers = subValuesCheckers;
    }

    @Override
    public void begin(SafeTreeReporter safeTreeReporter) {
        this.call(SubValuesChecker::begin, safeTreeReporter);
    }

    @Override
    public Consumer<SafeTreeReporter> present(Key key, Object value) {
        return this.getMergedConsumer(subValuesChecker -> subValuesChecker.present(key, value));
    }

    @Override
    public Consumer<SafeTreeReporter> absent(Key key) {
        return this.getMergedConsumer(subValuesChecker -> subValuesChecker.absent(key));
    }

    @Override
    public Consumer<SafeTreeReporter> broken(Key key, Throwable throwable) {
        return this.getMergedConsumer(subValuesChecker -> subValuesChecker.broken(key, throwable));
    }

    @Override
    public void end(SafeTreeReporter safeTreeReporter) {
        this.call(SubValuesChecker::end, safeTreeReporter);
    }

    private void call(BiConsumer<SubValuesChecker, SafeTreeReporter> method, SafeTreeReporter safeTreeReporter) {
        for (SubValuesChecker subValuesChecker : this.subValuesCheckers) {
            method.accept(subValuesChecker, safeTreeReporter);
        }
    }

    public Consumer<SafeTreeReporter> getMergedConsumer(Function<SubValuesChecker, Consumer<SafeTreeReporter>> function) {
        ArrayList<Consumer<SafeTreeReporter>> results = new ArrayList<Consumer<SafeTreeReporter>>();
        for (SubValuesChecker subValuesChecker : this.subValuesCheckers) {
            results.add(function.apply(subValuesChecker));
        }
        return safeTreeReporter -> {
            for (Consumer result : results) {
                result.accept(safeTreeReporter);
            }
        };
    }
}

