/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.reporters;

import com.github.alkedr.matchers.reporting.reporters.CloseableSafeTreeReporter;
import com.github.alkedr.matchers.reporting.reporters.Reporters;
import com.github.alkedr.matchers.reporting.reporters.SafeTreeReporter;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

class MergingSafeTreeReporter
implements CloseableSafeTreeReporter {
    protected final SafeTreeReporter reporter;
    private final Map<Node, Collection<Consumer<SafeTreeReporter>>> nodes = new LinkedHashMap<Node, Collection<Consumer<SafeTreeReporter>>>();

    MergingSafeTreeReporter(SafeTreeReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void close() {
        for (Map.Entry<Node, Collection<Consumer<SafeTreeReporter>>> entry : this.nodes.entrySet()) {
            entry.getKey().addToReporter(this.reporter, new MergedNodeContents(entry.getValue()));
        }
        this.nodes.clear();
    }

    @Override
    public void presentNode(Key key, Object value, Consumer<SafeTreeReporter> contents) {
        this.nodes.computeIfAbsent(new PresentNode(key, value), k -> new ArrayList()).add(contents);
    }

    @Override
    public void absentNode(Key key, Consumer<SafeTreeReporter> contents) {
        this.nodes.computeIfAbsent(new AbsentNode(key), k -> new ArrayList()).add(contents);
    }

    @Override
    public void brokenNode(Key key, Throwable throwable, Consumer<SafeTreeReporter> contents) {
        this.nodes.computeIfAbsent(new BrokenNode(key, throwable), k -> new ArrayList()).add(contents);
    }

    @Override
    public void correctlyPresent() {
        this.reporter.correctlyPresent();
    }

    @Override
    public void correctlyAbsent() {
        this.reporter.correctlyAbsent();
    }

    @Override
    public void incorrectlyPresent() {
        this.reporter.incorrectlyPresent();
    }

    @Override
    public void incorrectlyAbsent() {
        this.reporter.incorrectlyAbsent();
    }

    @Override
    public void passedCheck(String description) {
        this.reporter.passedCheck(description);
    }

    @Override
    public void failedCheck(String expected, String actual) {
        this.reporter.failedCheck(expected, actual);
    }

    @Override
    public void checkForAbsentItem(String description) {
        this.reporter.checkForAbsentItem(description);
    }

    @Override
    public void brokenCheck(String description, Throwable throwable) {
        this.reporter.brokenCheck(description, throwable);
    }

    private static class MergedNodeContents
    implements Consumer<SafeTreeReporter> {
        private final Collection<Consumer<SafeTreeReporter>> contentsCollection;

        MergedNodeContents(Collection<Consumer<SafeTreeReporter>> contentsCollection) {
            this.contentsCollection = contentsCollection;
        }

        @Override
        public void accept(SafeTreeReporter reporter) {
            try (CloseableSafeTreeReporter mergingReporter = Reporters.mergingReporter(reporter);){
                for (Consumer<SafeTreeReporter> contents : this.contentsCollection) {
                    contents.accept(mergingReporter);
                }
            }
        }
    }

    static class BrokenNode
    implements Node {
        final Key key;
        final Throwable throwable;

        BrokenNode(Key key, Throwable throwable) {
            this.key = key;
            this.throwable = throwable;
        }

        @Override
        public void addToReporter(SafeTreeReporter safeTreeReporter, Consumer<SafeTreeReporter> contents) {
            safeTreeReporter.brokenNode(this.key, this.throwable, contents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BrokenNode that = (BrokenNode)o;
            return this.key.equals(that.key) && this.throwable.equals(that.throwable);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.throwable.hashCode();
            return result;
        }
    }

    static class AbsentNode
    implements Node {
        final Key key;

        AbsentNode(Key key) {
            this.key = key;
        }

        @Override
        public void addToReporter(SafeTreeReporter safeTreeReporter, Consumer<SafeTreeReporter> contents) {
            safeTreeReporter.absentNode(this.key, contents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbsentNode that = (AbsentNode)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    static class PresentNode
    implements Node {
        final Key key;
        final Object value;

        PresentNode(Key key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void addToReporter(SafeTreeReporter safeTreeReporter, Consumer<SafeTreeReporter> contents) {
            safeTreeReporter.presentNode(this.key, this.value, contents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PresentNode that = (PresentNode)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    static interface Node {
        public void addToReporter(SafeTreeReporter var1, Consumer<SafeTreeReporter> var2);
    }
}

