/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting.reporters;

import com.github.alkedr.matchers.reporting.reporters.CloseableSimpleTreeReporter;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import java.io.IOException;
import java.util.Scanner;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

class HtmlReporter
implements CloseableSimpleTreeReporter {
    private static final String HTML_BEGIN;
    private static final String HTML_END;
    private final Appendable appendable;

    @Deprecated
    HtmlReporter(Appendable appendable, String title) {
        this(appendable);
    }

    HtmlReporter(Appendable appendable) {
        this.appendable = appendable;
        this.append(HTML_BEGIN);
    }

    @Override
    public void close() {
        this.append(HTML_END);
    }

    @Override
    public void beginPresentNode(Key key, Object value) {
        this.append("presentNode(\"");
        this.append(StringEscapeUtils.escapeJson((String)key.asString()));
        this.append("\",");
        if (value == null) {
            this.append("null");
        } else if (ClassUtils.isPrimitiveOrWrapper(value.getClass()) || value instanceof String) {
            this.append("\"");
            this.append(value.toString());
            this.append("\"");
        } else {
            this.append("\"\"");
        }
        this.append(",[");
    }

    @Override
    public void beginAbsentNode(Key key) {
        this.append("absentNode(\"");
        this.append(StringEscapeUtils.escapeJson((String)key.asString()));
        this.append("\",[");
    }

    @Override
    public void beginBrokenNode(Key key, Throwable throwable) {
        this.append("brokenNode(\"");
        this.append(StringEscapeUtils.escapeJson((String)key.asString()));
        this.append("\",\"");
        this.append(StringEscapeUtils.escapeJson((String)ExceptionUtils.getStackTrace((Throwable)throwable)));
        this.append("\",[");
    }

    @Override
    public void endNode() {
        this.append("]),");
    }

    @Override
    public void correctlyPresent() {
        this.append("correctlyPresent(),");
    }

    @Override
    public void correctlyAbsent() {
        this.append("correctlyAbsent(),");
    }

    @Override
    public void incorrectlyPresent() {
        this.append("incorrectlyPresent(),");
    }

    @Override
    public void incorrectlyAbsent() {
        this.append("incorrectlyAbsent(),");
    }

    @Override
    public void passedCheck(String description) {
        this.append("passedCheck(\"");
        this.append(StringEscapeUtils.escapeJson((String)description));
        this.append("\"),");
    }

    @Override
    public void failedCheck(String expected, String actual) {
        this.append("failedCheck(\"");
        this.append(StringEscapeUtils.escapeJson((String)expected));
        this.append("\",\"");
        this.append(StringEscapeUtils.escapeJson((String)actual));
        this.append("\"),");
    }

    @Override
    public void checkForAbsentItem(String description) {
        this.append("checkForAbsentItem(\"");
        this.append(StringEscapeUtils.escapeJson((String)description));
        this.append("\"),");
    }

    @Override
    public void brokenCheck(String description, Throwable throwable) {
        this.append("brokenCheck(\"");
        this.append(StringEscapeUtils.escapeJson((String)description));
        this.append("\",\"");
        this.append(StringEscapeUtils.escapeJson((String)ExceptionUtils.getStackTrace((Throwable)throwable)));
        this.append("\"),");
    }

    private void append(CharSequence charSequence) {
        try {
            this.appendable.append(charSequence);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String resourceFileToString(String name) {
        return new Scanner(HtmlReporter.class.getResourceAsStream(name), "UTF-8").useDelimiter("\\A").next();
    }

    static {
        String htmlTemplate = HtmlReporter.resourceFileToString("/report.html");
        String css = HtmlReporter.resourceFileToString("/report.css");
        String js = HtmlReporter.resourceFileToString("/report.js");
        String[] checksSplit = htmlTemplate.split("@@CHECKS@@");
        HTML_BEGIN = checksSplit[0].replaceFirst("@@JS@@", js).replaceFirst("@@CSS@@", css);
        HTML_END = checksSplit[1];
    }
}

