/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting;

import com.github.alkedr.matchers.reporting.BaseReportingMatcher;
import com.github.alkedr.matchers.reporting.reporters.SafeTreeReporter;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.keys.Key;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;

class SubValuesMatcher<T, S>
extends BaseReportingMatcher<T> {
    private final SubValuesExtractor<T, S> subValuesExtractor;
    private final Supplier<SubValuesChecker> subValuesCheckerSupplier;

    SubValuesMatcher(SubValuesExtractor<T, S> subValuesExtractor, Supplier<SubValuesChecker> subValuesCheckerSupplier) {
        Validate.notNull(subValuesExtractor, (String)"subValuesExtractor", (Object[])new Object[0]);
        Validate.notNull(subValuesCheckerSupplier, (String)"subValuesCheckerSupplier", (Object[])new Object[0]);
        this.subValuesExtractor = subValuesExtractor;
        this.subValuesCheckerSupplier = subValuesCheckerSupplier;
    }

    @Override
    public void run(Object item, SafeTreeReporter safeTreeReporter) {
        SubValuesChecker subValuesChecker = this.subValuesCheckerSupplier.get();
        subValuesChecker.begin(safeTreeReporter);
        this.subValuesExtractor.run(item, new CheckingSubValuesListener(safeTreeReporter, subValuesChecker));
        subValuesChecker.end(safeTreeReporter);
    }

    @Override
    public void runForAbsentItem(SafeTreeReporter safeTreeReporter) {
        SubValuesChecker subValuesChecker = this.subValuesCheckerSupplier.get();
        subValuesChecker.begin(safeTreeReporter);
        subValuesChecker.end(safeTreeReporter);
    }

    private static class CheckingSubValuesListener<S>
    implements SubValuesExtractor.SubValuesListener<S> {
        private final SafeTreeReporter safeTreeReporter;
        private final SubValuesChecker subValuesChecker;

        CheckingSubValuesListener(SafeTreeReporter safeTreeReporter, SubValuesChecker subValuesChecker) {
            this.safeTreeReporter = safeTreeReporter;
            this.subValuesChecker = subValuesChecker;
        }

        @Override
        public void present(Key key, Object value) {
            this.safeTreeReporter.presentNode(key, value, this.subValuesChecker.present(key, value));
        }

        @Override
        public void absent(Key key) {
            this.safeTreeReporter.absentNode(key, this.subValuesChecker.absent(key));
        }

        @Override
        public void broken(Key key, Throwable throwable) {
            this.safeTreeReporter.brokenNode(key, throwable, this.subValuesChecker.broken(key, throwable));
        }
    }
}

